/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ssm.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ResourceDataSyncS3Destination {
    private String bucketName;
    @Nullable
    private String kmsKeyArn;
    @Nullable
    private String prefix;
    private String region;
    @Nullable
    private String syncFormat;

    private ResourceDataSyncS3Destination() {
    }

    public String bucketName() {
        return this.bucketName;
    }

    public Optional<String> kmsKeyArn() {
        return Optional.ofNullable(this.kmsKeyArn);
    }

    public Optional<String> prefix() {
        return Optional.ofNullable(this.prefix);
    }

    public String region() {
        return this.region;
    }

    public Optional<String> syncFormat() {
        return Optional.ofNullable(this.syncFormat);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ResourceDataSyncS3Destination defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String bucketName;
        @Nullable
        private String kmsKeyArn;
        @Nullable
        private String prefix;
        private String region;
        @Nullable
        private String syncFormat;

        public Builder() {
        }

        public Builder(ResourceDataSyncS3Destination defaults) {
            Objects.requireNonNull(defaults);
            this.bucketName = defaults.bucketName;
            this.kmsKeyArn = defaults.kmsKeyArn;
            this.prefix = defaults.prefix;
            this.region = defaults.region;
            this.syncFormat = defaults.syncFormat;
        }

        @CustomType.Setter
        public Builder bucketName(String bucketName) {
            this.bucketName = Objects.requireNonNull(bucketName);
            return this;
        }

        @CustomType.Setter
        public Builder kmsKeyArn(@Nullable String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @CustomType.Setter
        public Builder prefix(@Nullable String prefix) {
            this.prefix = prefix;
            return this;
        }

        @CustomType.Setter
        public Builder region(String region) {
            this.region = Objects.requireNonNull(region);
            return this;
        }

        @CustomType.Setter
        public Builder syncFormat(@Nullable String syncFormat) {
            this.syncFormat = syncFormat;
            return this;
        }

        public ResourceDataSyncS3Destination build() {
            ResourceDataSyncS3Destination o = new ResourceDataSyncS3Destination();
            o.bucketName = this.bucketName;
            o.kmsKeyArn = this.kmsKeyArn;
            o.prefix = this.prefix;
            o.region = this.region;
            o.syncFormat = this.syncFormat;
            return o;
        }
    }
}

