/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ssm.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;

@CustomType
public final class PatchBaselineSource {
    private String configuration;
    private String name;
    private List<String> products;

    private PatchBaselineSource() {
    }

    public String configuration() {
        return this.configuration;
    }

    public String name() {
        return this.name;
    }

    public List<String> products() {
        return this.products;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PatchBaselineSource defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String configuration;
        private String name;
        private List<String> products;

        public Builder() {
        }

        public Builder(PatchBaselineSource defaults) {
            Objects.requireNonNull(defaults);
            this.configuration = defaults.configuration;
            this.name = defaults.name;
            this.products = defaults.products;
        }

        @CustomType.Setter
        public Builder configuration(String configuration) {
            this.configuration = Objects.requireNonNull(configuration);
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        @CustomType.Setter
        public Builder products(List<String> products) {
            this.products = Objects.requireNonNull(products);
            return this;
        }

        public Builder products(String ... products) {
            return this.products(List.of(products));
        }

        public PatchBaselineSource build() {
            PatchBaselineSource o = new PatchBaselineSource();
            o.configuration = this.configuration;
            o.name = this.name;
            o.products = this.products;
            return o;
        }
    }
}

