/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ssm.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class AssociationOutputLocation {
    private String s3BucketName;
    @Nullable
    private String s3KeyPrefix;
    @Nullable
    private String s3Region;

    private AssociationOutputLocation() {
    }

    public String s3BucketName() {
        return this.s3BucketName;
    }

    public Optional<String> s3KeyPrefix() {
        return Optional.ofNullable(this.s3KeyPrefix);
    }

    public Optional<String> s3Region() {
        return Optional.ofNullable(this.s3Region);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AssociationOutputLocation defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String s3BucketName;
        @Nullable
        private String s3KeyPrefix;
        @Nullable
        private String s3Region;

        public Builder() {
        }

        public Builder(AssociationOutputLocation defaults) {
            Objects.requireNonNull(defaults);
            this.s3BucketName = defaults.s3BucketName;
            this.s3KeyPrefix = defaults.s3KeyPrefix;
            this.s3Region = defaults.s3Region;
        }

        @CustomType.Setter
        public Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = Objects.requireNonNull(s3BucketName);
            return this;
        }

        @CustomType.Setter
        public Builder s3KeyPrefix(@Nullable String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        @CustomType.Setter
        public Builder s3Region(@Nullable String s3Region) {
            this.s3Region = s3Region;
            return this;
        }

        public AssociationOutputLocation build() {
            AssociationOutputLocation o = new AssociationOutputLocation();
            o.s3BucketName = this.s3BucketName;
            o.s3KeyPrefix = this.s3KeyPrefix;
            o.s3Region = this.s3Region;
            return o;
        }
    }
}

