/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.servicediscovery.outputs;

import com.pulumi.aws.servicediscovery.outputs.ServiceDnsConfigDnsRecord;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ServiceDnsConfig {
    private List<ServiceDnsConfigDnsRecord> dnsRecords;
    private String namespaceId;
    @Nullable
    private String routingPolicy;

    private ServiceDnsConfig() {
    }

    public List<ServiceDnsConfigDnsRecord> dnsRecords() {
        return this.dnsRecords;
    }

    public String namespaceId() {
        return this.namespaceId;
    }

    public Optional<String> routingPolicy() {
        return Optional.ofNullable(this.routingPolicy);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ServiceDnsConfig defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<ServiceDnsConfigDnsRecord> dnsRecords;
        private String namespaceId;
        @Nullable
        private String routingPolicy;

        public Builder() {
        }

        public Builder(ServiceDnsConfig defaults) {
            Objects.requireNonNull(defaults);
            this.dnsRecords = defaults.dnsRecords;
            this.namespaceId = defaults.namespaceId;
            this.routingPolicy = defaults.routingPolicy;
        }

        @CustomType.Setter
        public Builder dnsRecords(List<ServiceDnsConfigDnsRecord> dnsRecords) {
            this.dnsRecords = Objects.requireNonNull(dnsRecords);
            return this;
        }

        public Builder dnsRecords(ServiceDnsConfigDnsRecord ... dnsRecords) {
            return this.dnsRecords(List.of(dnsRecords));
        }

        @CustomType.Setter
        public Builder namespaceId(String namespaceId) {
            this.namespaceId = Objects.requireNonNull(namespaceId);
            return this;
        }

        @CustomType.Setter
        public Builder routingPolicy(@Nullable String routingPolicy) {
            this.routingPolicy = routingPolicy;
            return this;
        }

        public ServiceDnsConfig build() {
            ServiceDnsConfig o = new ServiceDnsConfig();
            o.dnsRecords = this.dnsRecords;
            o.namespaceId = this.namespaceId;
            o.routingPolicy = this.routingPolicy;
            return o;
        }
    }
}

