/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.sagemaker.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class CodeRepositoryGitConfig {
    @Nullable
    private String branch;
    private String repositoryUrl;
    @Nullable
    private String secretArn;

    private CodeRepositoryGitConfig() {
    }

    public Optional<String> branch() {
        return Optional.ofNullable(this.branch);
    }

    public String repositoryUrl() {
        return this.repositoryUrl;
    }

    public Optional<String> secretArn() {
        return Optional.ofNullable(this.secretArn);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CodeRepositoryGitConfig defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String branch;
        private String repositoryUrl;
        @Nullable
        private String secretArn;

        public Builder() {
        }

        public Builder(CodeRepositoryGitConfig defaults) {
            Objects.requireNonNull(defaults);
            this.branch = defaults.branch;
            this.repositoryUrl = defaults.repositoryUrl;
            this.secretArn = defaults.secretArn;
        }

        @CustomType.Setter
        public Builder branch(@Nullable String branch) {
            this.branch = branch;
            return this;
        }

        @CustomType.Setter
        public Builder repositoryUrl(String repositoryUrl) {
            this.repositoryUrl = Objects.requireNonNull(repositoryUrl);
            return this;
        }

        @CustomType.Setter
        public Builder secretArn(@Nullable String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public CodeRepositoryGitConfig build() {
            CodeRepositoryGitConfig o = new CodeRepositoryGitConfig();
            o.branch = this.branch;
            o.repositoryUrl = this.repositoryUrl;
            o.secretArn = this.secretArn;
            return o;
        }
    }
}

