/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.s3control.outputs;

import com.pulumi.aws.s3control.outputs.ObjectLambdaAccessPointConfigurationTransformationConfiguration;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ObjectLambdaAccessPointConfiguration {
    @Nullable
    private List<String> allowedFeatures;
    @Nullable
    private Boolean cloudWatchMetricsEnabled;
    private String supportingAccessPoint;
    private List<ObjectLambdaAccessPointConfigurationTransformationConfiguration> transformationConfigurations;

    private ObjectLambdaAccessPointConfiguration() {
    }

    public List<String> allowedFeatures() {
        return this.allowedFeatures == null ? List.of() : this.allowedFeatures;
    }

    public Optional<Boolean> cloudWatchMetricsEnabled() {
        return Optional.ofNullable(this.cloudWatchMetricsEnabled);
    }

    public String supportingAccessPoint() {
        return this.supportingAccessPoint;
    }

    public List<ObjectLambdaAccessPointConfigurationTransformationConfiguration> transformationConfigurations() {
        return this.transformationConfigurations;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ObjectLambdaAccessPointConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<String> allowedFeatures;
        @Nullable
        private Boolean cloudWatchMetricsEnabled;
        private String supportingAccessPoint;
        private List<ObjectLambdaAccessPointConfigurationTransformationConfiguration> transformationConfigurations;

        public Builder() {
        }

        public Builder(ObjectLambdaAccessPointConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.allowedFeatures = defaults.allowedFeatures;
            this.cloudWatchMetricsEnabled = defaults.cloudWatchMetricsEnabled;
            this.supportingAccessPoint = defaults.supportingAccessPoint;
            this.transformationConfigurations = defaults.transformationConfigurations;
        }

        @CustomType.Setter
        public Builder allowedFeatures(@Nullable List<String> allowedFeatures) {
            this.allowedFeatures = allowedFeatures;
            return this;
        }

        public Builder allowedFeatures(String ... allowedFeatures) {
            return this.allowedFeatures(List.of(allowedFeatures));
        }

        @CustomType.Setter
        public Builder cloudWatchMetricsEnabled(@Nullable Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
            return this;
        }

        @CustomType.Setter
        public Builder supportingAccessPoint(String supportingAccessPoint) {
            this.supportingAccessPoint = Objects.requireNonNull(supportingAccessPoint);
            return this;
        }

        @CustomType.Setter
        public Builder transformationConfigurations(List<ObjectLambdaAccessPointConfigurationTransformationConfiguration> transformationConfigurations) {
            this.transformationConfigurations = Objects.requireNonNull(transformationConfigurations);
            return this;
        }

        public Builder transformationConfigurations(ObjectLambdaAccessPointConfigurationTransformationConfiguration ... transformationConfigurations) {
            return this.transformationConfigurations(List.of(transformationConfigurations));
        }

        public ObjectLambdaAccessPointConfiguration build() {
            ObjectLambdaAccessPointConfiguration o = new ObjectLambdaAccessPointConfiguration();
            o.allowedFeatures = this.allowedFeatures;
            o.cloudWatchMetricsEnabled = this.cloudWatchMetricsEnabled;
            o.supportingAccessPoint = this.supportingAccessPoint;
            o.transformationConfigurations = this.transformationConfigurations;
            return o;
        }
    }
}

