/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.s3.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class BucketCorsRule {
    @Nullable
    private List<String> allowedHeaders;
    private List<String> allowedMethods;
    private List<String> allowedOrigins;
    @Nullable
    private List<String> exposeHeaders;
    @Nullable
    private Integer maxAgeSeconds;

    private BucketCorsRule() {
    }

    public List<String> allowedHeaders() {
        return this.allowedHeaders == null ? List.of() : this.allowedHeaders;
    }

    public List<String> allowedMethods() {
        return this.allowedMethods;
    }

    public List<String> allowedOrigins() {
        return this.allowedOrigins;
    }

    public List<String> exposeHeaders() {
        return this.exposeHeaders == null ? List.of() : this.exposeHeaders;
    }

    public Optional<Integer> maxAgeSeconds() {
        return Optional.ofNullable(this.maxAgeSeconds);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BucketCorsRule defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<String> allowedHeaders;
        private List<String> allowedMethods;
        private List<String> allowedOrigins;
        @Nullable
        private List<String> exposeHeaders;
        @Nullable
        private Integer maxAgeSeconds;

        public Builder() {
        }

        public Builder(BucketCorsRule defaults) {
            Objects.requireNonNull(defaults);
            this.allowedHeaders = defaults.allowedHeaders;
            this.allowedMethods = defaults.allowedMethods;
            this.allowedOrigins = defaults.allowedOrigins;
            this.exposeHeaders = defaults.exposeHeaders;
            this.maxAgeSeconds = defaults.maxAgeSeconds;
        }

        @CustomType.Setter
        public Builder allowedHeaders(@Nullable List<String> allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
            return this;
        }

        public Builder allowedHeaders(String ... allowedHeaders) {
            return this.allowedHeaders(List.of(allowedHeaders));
        }

        @CustomType.Setter
        public Builder allowedMethods(List<String> allowedMethods) {
            this.allowedMethods = Objects.requireNonNull(allowedMethods);
            return this;
        }

        public Builder allowedMethods(String ... allowedMethods) {
            return this.allowedMethods(List.of(allowedMethods));
        }

        @CustomType.Setter
        public Builder allowedOrigins(List<String> allowedOrigins) {
            this.allowedOrigins = Objects.requireNonNull(allowedOrigins);
            return this;
        }

        public Builder allowedOrigins(String ... allowedOrigins) {
            return this.allowedOrigins(List.of(allowedOrigins));
        }

        @CustomType.Setter
        public Builder exposeHeaders(@Nullable List<String> exposeHeaders) {
            this.exposeHeaders = exposeHeaders;
            return this;
        }

        public Builder exposeHeaders(String ... exposeHeaders) {
            return this.exposeHeaders(List.of(exposeHeaders));
        }

        @CustomType.Setter
        public Builder maxAgeSeconds(@Nullable Integer maxAgeSeconds) {
            this.maxAgeSeconds = maxAgeSeconds;
            return this;
        }

        public BucketCorsRule build() {
            BucketCorsRule o = new BucketCorsRule();
            o.allowedHeaders = this.allowedHeaders;
            o.allowedMethods = this.allowedMethods;
            o.allowedOrigins = this.allowedOrigins;
            o.exposeHeaders = this.exposeHeaders;
            o.maxAgeSeconds = this.maxAgeSeconds;
            return o;
        }
    }
}

