/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.s3.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class AccessPointPublicAccessBlockConfiguration {
    @Nullable
    private Boolean blockPublicAcls;
    @Nullable
    private Boolean blockPublicPolicy;
    @Nullable
    private Boolean ignorePublicAcls;
    @Nullable
    private Boolean restrictPublicBuckets;

    private AccessPointPublicAccessBlockConfiguration() {
    }

    public Optional<Boolean> blockPublicAcls() {
        return Optional.ofNullable(this.blockPublicAcls);
    }

    public Optional<Boolean> blockPublicPolicy() {
        return Optional.ofNullable(this.blockPublicPolicy);
    }

    public Optional<Boolean> ignorePublicAcls() {
        return Optional.ofNullable(this.ignorePublicAcls);
    }

    public Optional<Boolean> restrictPublicBuckets() {
        return Optional.ofNullable(this.restrictPublicBuckets);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AccessPointPublicAccessBlockConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean blockPublicAcls;
        @Nullable
        private Boolean blockPublicPolicy;
        @Nullable
        private Boolean ignorePublicAcls;
        @Nullable
        private Boolean restrictPublicBuckets;

        public Builder() {
        }

        public Builder(AccessPointPublicAccessBlockConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.blockPublicAcls = defaults.blockPublicAcls;
            this.blockPublicPolicy = defaults.blockPublicPolicy;
            this.ignorePublicAcls = defaults.ignorePublicAcls;
            this.restrictPublicBuckets = defaults.restrictPublicBuckets;
        }

        @CustomType.Setter
        public Builder blockPublicAcls(@Nullable Boolean blockPublicAcls) {
            this.blockPublicAcls = blockPublicAcls;
            return this;
        }

        @CustomType.Setter
        public Builder blockPublicPolicy(@Nullable Boolean blockPublicPolicy) {
            this.blockPublicPolicy = blockPublicPolicy;
            return this;
        }

        @CustomType.Setter
        public Builder ignorePublicAcls(@Nullable Boolean ignorePublicAcls) {
            this.ignorePublicAcls = ignorePublicAcls;
            return this;
        }

        @CustomType.Setter
        public Builder restrictPublicBuckets(@Nullable Boolean restrictPublicBuckets) {
            this.restrictPublicBuckets = restrictPublicBuckets;
            return this;
        }

        public AccessPointPublicAccessBlockConfiguration build() {
            AccessPointPublicAccessBlockConfiguration o = new AccessPointPublicAccessBlockConfiguration();
            o.blockPublicAcls = this.blockPublicAcls;
            o.blockPublicPolicy = this.blockPublicPolicy;
            o.ignorePublicAcls = this.ignorePublicAcls;
            o.restrictPublicBuckets = this.restrictPublicBuckets;
            return o;
        }
    }
}

