/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.s3;

import com.pulumi.aws.s3.inputs.BucketLoggingV2TargetGrantArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class BucketLoggingV2Args
extends ResourceArgs {
    public static final BucketLoggingV2Args Empty = new BucketLoggingV2Args();
    @Import(name="bucket", required=true)
    private Output<String> bucket;
    @Import(name="expectedBucketOwner")
    @Nullable
    private Output<String> expectedBucketOwner;
    @Import(name="targetBucket", required=true)
    private Output<String> targetBucket;
    @Import(name="targetGrants")
    @Nullable
    private Output<List<BucketLoggingV2TargetGrantArgs>> targetGrants;
    @Import(name="targetPrefix", required=true)
    private Output<String> targetPrefix;

    public Output<String> bucket() {
        return this.bucket;
    }

    public Optional<Output<String>> expectedBucketOwner() {
        return Optional.ofNullable(this.expectedBucketOwner);
    }

    public Output<String> targetBucket() {
        return this.targetBucket;
    }

    public Optional<Output<List<BucketLoggingV2TargetGrantArgs>>> targetGrants() {
        return Optional.ofNullable(this.targetGrants);
    }

    public Output<String> targetPrefix() {
        return this.targetPrefix;
    }

    private BucketLoggingV2Args() {
    }

    private BucketLoggingV2Args(BucketLoggingV2Args $) {
        this.bucket = $.bucket;
        this.expectedBucketOwner = $.expectedBucketOwner;
        this.targetBucket = $.targetBucket;
        this.targetGrants = $.targetGrants;
        this.targetPrefix = $.targetPrefix;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BucketLoggingV2Args defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private BucketLoggingV2Args $;

        public Builder() {
            this.$ = new BucketLoggingV2Args();
        }

        public Builder(BucketLoggingV2Args defaults) {
            this.$ = new BucketLoggingV2Args(Objects.requireNonNull(defaults));
        }

        public Builder bucket(Output<String> bucket) {
            this.$.bucket = bucket;
            return this;
        }

        public Builder bucket(String bucket) {
            return this.bucket((Output<String>)Output.of((Object)bucket));
        }

        public Builder expectedBucketOwner(@Nullable Output<String> expectedBucketOwner) {
            this.$.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        public Builder expectedBucketOwner(String expectedBucketOwner) {
            return this.expectedBucketOwner((Output<String>)Output.of((Object)expectedBucketOwner));
        }

        public Builder targetBucket(Output<String> targetBucket) {
            this.$.targetBucket = targetBucket;
            return this;
        }

        public Builder targetBucket(String targetBucket) {
            return this.targetBucket((Output<String>)Output.of((Object)targetBucket));
        }

        public Builder targetGrants(@Nullable Output<List<BucketLoggingV2TargetGrantArgs>> targetGrants) {
            this.$.targetGrants = targetGrants;
            return this;
        }

        public Builder targetGrants(List<BucketLoggingV2TargetGrantArgs> targetGrants) {
            return this.targetGrants((Output<List<BucketLoggingV2TargetGrantArgs>>)Output.of(targetGrants));
        }

        public Builder targetGrants(BucketLoggingV2TargetGrantArgs ... targetGrants) {
            return this.targetGrants(List.of(targetGrants));
        }

        public Builder targetPrefix(Output<String> targetPrefix) {
            this.$.targetPrefix = targetPrefix;
            return this;
        }

        public Builder targetPrefix(String targetPrefix) {
            return this.targetPrefix((Output<String>)Output.of((Object)targetPrefix));
        }

        public BucketLoggingV2Args build() {
            this.$.bucket = Objects.requireNonNull(this.$.bucket, "expected parameter 'bucket' to be non-null");
            this.$.targetBucket = Objects.requireNonNull(this.$.targetBucket, "expected parameter 'targetBucket' to be non-null");
            this.$.targetPrefix = Objects.requireNonNull(this.$.targetPrefix, "expected parameter 'targetPrefix' to be non-null");
            return this.$;
        }
    }
}

