/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.redshift;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class EndpointAccessArgs
extends ResourceArgs {
    public static final EndpointAccessArgs Empty = new EndpointAccessArgs();
    @Import(name="clusterIdentifier", required=true)
    private Output<String> clusterIdentifier;
    @Import(name="endpointName", required=true)
    private Output<String> endpointName;
    @Import(name="resourceOwner")
    @Nullable
    private Output<String> resourceOwner;
    @Import(name="subnetGroupName", required=true)
    private Output<String> subnetGroupName;
    @Import(name="vpcSecurityGroupIds")
    @Nullable
    private Output<List<String>> vpcSecurityGroupIds;

    public Output<String> clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public Output<String> endpointName() {
        return this.endpointName;
    }

    public Optional<Output<String>> resourceOwner() {
        return Optional.ofNullable(this.resourceOwner);
    }

    public Output<String> subnetGroupName() {
        return this.subnetGroupName;
    }

    public Optional<Output<List<String>>> vpcSecurityGroupIds() {
        return Optional.ofNullable(this.vpcSecurityGroupIds);
    }

    private EndpointAccessArgs() {
    }

    private EndpointAccessArgs(EndpointAccessArgs $) {
        this.clusterIdentifier = $.clusterIdentifier;
        this.endpointName = $.endpointName;
        this.resourceOwner = $.resourceOwner;
        this.subnetGroupName = $.subnetGroupName;
        this.vpcSecurityGroupIds = $.vpcSecurityGroupIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EndpointAccessArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private EndpointAccessArgs $;

        public Builder() {
            this.$ = new EndpointAccessArgs();
        }

        public Builder(EndpointAccessArgs defaults) {
            this.$ = new EndpointAccessArgs(Objects.requireNonNull(defaults));
        }

        public Builder clusterIdentifier(Output<String> clusterIdentifier) {
            this.$.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public Builder clusterIdentifier(String clusterIdentifier) {
            return this.clusterIdentifier((Output<String>)Output.of((Object)clusterIdentifier));
        }

        public Builder endpointName(Output<String> endpointName) {
            this.$.endpointName = endpointName;
            return this;
        }

        public Builder endpointName(String endpointName) {
            return this.endpointName((Output<String>)Output.of((Object)endpointName));
        }

        public Builder resourceOwner(@Nullable Output<String> resourceOwner) {
            this.$.resourceOwner = resourceOwner;
            return this;
        }

        public Builder resourceOwner(String resourceOwner) {
            return this.resourceOwner((Output<String>)Output.of((Object)resourceOwner));
        }

        public Builder subnetGroupName(Output<String> subnetGroupName) {
            this.$.subnetGroupName = subnetGroupName;
            return this;
        }

        public Builder subnetGroupName(String subnetGroupName) {
            return this.subnetGroupName((Output<String>)Output.of((Object)subnetGroupName));
        }

        public Builder vpcSecurityGroupIds(@Nullable Output<List<String>> vpcSecurityGroupIds) {
            this.$.vpcSecurityGroupIds = vpcSecurityGroupIds;
            return this;
        }

        public Builder vpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
            return this.vpcSecurityGroupIds((Output<List<String>>)Output.of(vpcSecurityGroupIds));
        }

        public Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            return this.vpcSecurityGroupIds(List.of(vpcSecurityGroupIds));
        }

        public EndpointAccessArgs build() {
            this.$.clusterIdentifier = Objects.requireNonNull(this.$.clusterIdentifier, "expected parameter 'clusterIdentifier' to be non-null");
            this.$.endpointName = Objects.requireNonNull(this.$.endpointName, "expected parameter 'endpointName' to be non-null");
            this.$.subnetGroupName = Objects.requireNonNull(this.$.subnetGroupName, "expected parameter 'subnetGroupName' to be non-null");
            return this.$;
        }
    }
}

