/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.rds.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ProxyDefaultTargetGroupConnectionPoolConfig {
    @Nullable
    private Integer connectionBorrowTimeout;
    @Nullable
    private String initQuery;
    @Nullable
    private Integer maxConnectionsPercent;
    @Nullable
    private Integer maxIdleConnectionsPercent;
    @Nullable
    private List<String> sessionPinningFilters;

    private ProxyDefaultTargetGroupConnectionPoolConfig() {
    }

    public Optional<Integer> connectionBorrowTimeout() {
        return Optional.ofNullable(this.connectionBorrowTimeout);
    }

    public Optional<String> initQuery() {
        return Optional.ofNullable(this.initQuery);
    }

    public Optional<Integer> maxConnectionsPercent() {
        return Optional.ofNullable(this.maxConnectionsPercent);
    }

    public Optional<Integer> maxIdleConnectionsPercent() {
        return Optional.ofNullable(this.maxIdleConnectionsPercent);
    }

    public List<String> sessionPinningFilters() {
        return this.sessionPinningFilters == null ? List.of() : this.sessionPinningFilters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProxyDefaultTargetGroupConnectionPoolConfig defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer connectionBorrowTimeout;
        @Nullable
        private String initQuery;
        @Nullable
        private Integer maxConnectionsPercent;
        @Nullable
        private Integer maxIdleConnectionsPercent;
        @Nullable
        private List<String> sessionPinningFilters;

        public Builder() {
        }

        public Builder(ProxyDefaultTargetGroupConnectionPoolConfig defaults) {
            Objects.requireNonNull(defaults);
            this.connectionBorrowTimeout = defaults.connectionBorrowTimeout;
            this.initQuery = defaults.initQuery;
            this.maxConnectionsPercent = defaults.maxConnectionsPercent;
            this.maxIdleConnectionsPercent = defaults.maxIdleConnectionsPercent;
            this.sessionPinningFilters = defaults.sessionPinningFilters;
        }

        @CustomType.Setter
        public Builder connectionBorrowTimeout(@Nullable Integer connectionBorrowTimeout) {
            this.connectionBorrowTimeout = connectionBorrowTimeout;
            return this;
        }

        @CustomType.Setter
        public Builder initQuery(@Nullable String initQuery) {
            this.initQuery = initQuery;
            return this;
        }

        @CustomType.Setter
        public Builder maxConnectionsPercent(@Nullable Integer maxConnectionsPercent) {
            this.maxConnectionsPercent = maxConnectionsPercent;
            return this;
        }

        @CustomType.Setter
        public Builder maxIdleConnectionsPercent(@Nullable Integer maxIdleConnectionsPercent) {
            this.maxIdleConnectionsPercent = maxIdleConnectionsPercent;
            return this;
        }

        @CustomType.Setter
        public Builder sessionPinningFilters(@Nullable List<String> sessionPinningFilters) {
            this.sessionPinningFilters = sessionPinningFilters;
            return this;
        }

        public Builder sessionPinningFilters(String ... sessionPinningFilters) {
            return this.sessionPinningFilters(List.of(sessionPinningFilters));
        }

        public ProxyDefaultTargetGroupConnectionPoolConfig build() {
            ProxyDefaultTargetGroupConnectionPoolConfig o = new ProxyDefaultTargetGroupConnectionPoolConfig();
            o.connectionBorrowTimeout = this.connectionBorrowTimeout;
            o.initQuery = this.initQuery;
            o.maxConnectionsPercent = this.maxConnectionsPercent;
            o.maxIdleConnectionsPercent = this.maxIdleConnectionsPercent;
            o.sessionPinningFilters = this.sessionPinningFilters;
            return o;
        }
    }
}

