/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.rds.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ClusterRestoreToPointInTime {
    @Nullable
    private String restoreToTime;
    @Nullable
    private String restoreType;
    private String sourceClusterIdentifier;
    @Nullable
    private Boolean useLatestRestorableTime;

    private ClusterRestoreToPointInTime() {
    }

    public Optional<String> restoreToTime() {
        return Optional.ofNullable(this.restoreToTime);
    }

    public Optional<String> restoreType() {
        return Optional.ofNullable(this.restoreType);
    }

    public String sourceClusterIdentifier() {
        return this.sourceClusterIdentifier;
    }

    public Optional<Boolean> useLatestRestorableTime() {
        return Optional.ofNullable(this.useLatestRestorableTime);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterRestoreToPointInTime defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String restoreToTime;
        @Nullable
        private String restoreType;
        private String sourceClusterIdentifier;
        @Nullable
        private Boolean useLatestRestorableTime;

        public Builder() {
        }

        public Builder(ClusterRestoreToPointInTime defaults) {
            Objects.requireNonNull(defaults);
            this.restoreToTime = defaults.restoreToTime;
            this.restoreType = defaults.restoreType;
            this.sourceClusterIdentifier = defaults.sourceClusterIdentifier;
            this.useLatestRestorableTime = defaults.useLatestRestorableTime;
        }

        @CustomType.Setter
        public Builder restoreToTime(@Nullable String restoreToTime) {
            this.restoreToTime = restoreToTime;
            return this;
        }

        @CustomType.Setter
        public Builder restoreType(@Nullable String restoreType) {
            this.restoreType = restoreType;
            return this;
        }

        @CustomType.Setter
        public Builder sourceClusterIdentifier(String sourceClusterIdentifier) {
            this.sourceClusterIdentifier = Objects.requireNonNull(sourceClusterIdentifier);
            return this;
        }

        @CustomType.Setter
        public Builder useLatestRestorableTime(@Nullable Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        public ClusterRestoreToPointInTime build() {
            ClusterRestoreToPointInTime o = new ClusterRestoreToPointInTime();
            o.restoreToTime = this.restoreToTime;
            o.restoreType = this.restoreType;
            o.sourceClusterIdentifier = this.sourceClusterIdentifier;
            o.useLatestRestorableTime = this.useLatestRestorableTime;
            return o;
        }
    }
}

