/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ram.outputs;

import com.pulumi.aws.ram.outputs.GetResourceShareFilter;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GetResourceShareResult {
    private String arn;
    @Nullable
    private List<GetResourceShareFilter> filters;
    private String id;
    private String name;
    private String owningAccountId;
    private List<String> resourceArns;
    private String resourceOwner;
    @Nullable
    private String resourceShareStatus;
    private String status;
    private Map<String, String> tags;

    private GetResourceShareResult() {
    }

    public String arn() {
        return this.arn;
    }

    public List<GetResourceShareFilter> filters() {
        return this.filters == null ? List.of() : this.filters;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String owningAccountId() {
        return this.owningAccountId;
    }

    public List<String> resourceArns() {
        return this.resourceArns;
    }

    public String resourceOwner() {
        return this.resourceOwner;
    }

    public Optional<String> resourceShareStatus() {
        return Optional.ofNullable(this.resourceShareStatus);
    }

    public String status() {
        return this.status;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GetResourceShareResult defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String arn;
        @Nullable
        private List<GetResourceShareFilter> filters;
        private String id;
        private String name;
        private String owningAccountId;
        private List<String> resourceArns;
        private String resourceOwner;
        @Nullable
        private String resourceShareStatus;
        private String status;
        private Map<String, String> tags;

        public Builder() {
        }

        public Builder(GetResourceShareResult defaults) {
            Objects.requireNonNull(defaults);
            this.arn = defaults.arn;
            this.filters = defaults.filters;
            this.id = defaults.id;
            this.name = defaults.name;
            this.owningAccountId = defaults.owningAccountId;
            this.resourceArns = defaults.resourceArns;
            this.resourceOwner = defaults.resourceOwner;
            this.resourceShareStatus = defaults.resourceShareStatus;
            this.status = defaults.status;
            this.tags = defaults.tags;
        }

        @CustomType.Setter
        public Builder arn(String arn) {
            this.arn = Objects.requireNonNull(arn);
            return this;
        }

        @CustomType.Setter
        public Builder filters(@Nullable List<GetResourceShareFilter> filters) {
            this.filters = filters;
            return this;
        }

        public Builder filters(GetResourceShareFilter ... filters) {
            return this.filters(List.of(filters));
        }

        @CustomType.Setter
        public Builder id(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        @CustomType.Setter
        public Builder owningAccountId(String owningAccountId) {
            this.owningAccountId = Objects.requireNonNull(owningAccountId);
            return this;
        }

        @CustomType.Setter
        public Builder resourceArns(List<String> resourceArns) {
            this.resourceArns = Objects.requireNonNull(resourceArns);
            return this;
        }

        public Builder resourceArns(String ... resourceArns) {
            return this.resourceArns(List.of(resourceArns));
        }

        @CustomType.Setter
        public Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = Objects.requireNonNull(resourceOwner);
            return this;
        }

        @CustomType.Setter
        public Builder resourceShareStatus(@Nullable String resourceShareStatus) {
            this.resourceShareStatus = resourceShareStatus;
            return this;
        }

        @CustomType.Setter
        public Builder status(String status) {
            this.status = Objects.requireNonNull(status);
            return this;
        }

        @CustomType.Setter
        public Builder tags(Map<String, String> tags) {
            this.tags = Objects.requireNonNull(tags);
            return this;
        }

        public GetResourceShareResult build() {
            GetResourceShareResult o = new GetResourceShareResult();
            o.arn = this.arn;
            o.filters = this.filters;
            o.id = this.id;
            o.name = this.name;
            o.owningAccountId = this.owningAccountId;
            o.resourceArns = this.resourceArns;
            o.resourceOwner = this.resourceOwner;
            o.resourceShareStatus = this.resourceShareStatus;
            o.status = this.status;
            o.tags = this.tags;
            return o;
        }
    }
}

