/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.pinpoint;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.resources.ResourceArgs;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class BaiduChannelArgs
extends ResourceArgs {
    public static final BaiduChannelArgs Empty = new BaiduChannelArgs();
    @Import(name="apiKey", required=true)
    private Output<String> apiKey;
    @Import(name="applicationId", required=true)
    private Output<String> applicationId;
    @Import(name="enabled")
    @Nullable
    private Output<Boolean> enabled;
    @Import(name="secretKey", required=true)
    private Output<String> secretKey;

    public Output<String> apiKey() {
        return this.apiKey;
    }

    public Output<String> applicationId() {
        return this.applicationId;
    }

    public Optional<Output<Boolean>> enabled() {
        return Optional.ofNullable(this.enabled);
    }

    public Output<String> secretKey() {
        return this.secretKey;
    }

    private BaiduChannelArgs() {
    }

    private BaiduChannelArgs(BaiduChannelArgs $) {
        this.apiKey = $.apiKey;
        this.applicationId = $.applicationId;
        this.enabled = $.enabled;
        this.secretKey = $.secretKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BaiduChannelArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private BaiduChannelArgs $;

        public Builder() {
            this.$ = new BaiduChannelArgs();
        }

        public Builder(BaiduChannelArgs defaults) {
            this.$ = new BaiduChannelArgs(Objects.requireNonNull(defaults));
        }

        public Builder apiKey(Output<String> apiKey) {
            this.$.apiKey = apiKey;
            return this;
        }

        public Builder apiKey(String apiKey) {
            return this.apiKey((Output<String>)Output.of((Object)apiKey));
        }

        public Builder applicationId(Output<String> applicationId) {
            this.$.applicationId = applicationId;
            return this;
        }

        public Builder applicationId(String applicationId) {
            return this.applicationId((Output<String>)Output.of((Object)applicationId));
        }

        public Builder enabled(@Nullable Output<Boolean> enabled) {
            this.$.enabled = enabled;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            return this.enabled((Output<Boolean>)Output.of((Object)enabled));
        }

        public Builder secretKey(Output<String> secretKey) {
            this.$.secretKey = secretKey;
            return this;
        }

        public Builder secretKey(String secretKey) {
            return this.secretKey((Output<String>)Output.of((Object)secretKey));
        }

        public BaiduChannelArgs build() {
            this.$.apiKey = Objects.requireNonNull(this.$.apiKey, "expected parameter 'apiKey' to be non-null");
            this.$.applicationId = Objects.requireNonNull(this.$.applicationId, "expected parameter 'applicationId' to be non-null");
            this.$.secretKey = Objects.requireNonNull(this.$.secretKey, "expected parameter 'secretKey' to be non-null");
            return this.$;
        }
    }
}

