/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.organizations;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.organizations.OrganizationArgs;
import com.pulumi.aws.organizations.inputs.OrganizationState;
import com.pulumi.aws.organizations.outputs.OrganizationAccount;
import com.pulumi.aws.organizations.outputs.OrganizationNonMasterAccount;
import com.pulumi.aws.organizations.outputs.OrganizationRoot;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.resources.CustomResource;
import com.pulumi.resources.CustomResourceOptions;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

@ResourceType(type="aws:organizations/organization:Organization")
public class Organization
extends CustomResource {
    @Export(name="accounts", refs={List.class, OrganizationAccount.class}, tree="[0,1]")
    private Output<List<OrganizationAccount>> accounts;
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;
    @Export(name="awsServiceAccessPrincipals", refs={List.class, String.class}, tree="[0,1]")
    private Output<List<String>> awsServiceAccessPrincipals;
    @Export(name="enabledPolicyTypes", refs={List.class, String.class}, tree="[0,1]")
    private Output<List<String>> enabledPolicyTypes;
    @Export(name="featureSet", refs={String.class}, tree="[0]")
    private Output<String> featureSet;
    @Export(name="masterAccountArn", refs={String.class}, tree="[0]")
    private Output<String> masterAccountArn;
    @Export(name="masterAccountEmail", refs={String.class}, tree="[0]")
    private Output<String> masterAccountEmail;
    @Export(name="masterAccountId", refs={String.class}, tree="[0]")
    private Output<String> masterAccountId;
    @Export(name="nonMasterAccounts", refs={List.class, OrganizationNonMasterAccount.class}, tree="[0,1]")
    private Output<List<OrganizationNonMasterAccount>> nonMasterAccounts;
    @Export(name="roots", refs={List.class, OrganizationRoot.class}, tree="[0,1]")
    private Output<List<OrganizationRoot>> roots;

    public Output<List<OrganizationAccount>> accounts() {
        return this.accounts;
    }

    public Output<String> arn() {
        return this.arn;
    }

    public Output<Optional<List<String>>> awsServiceAccessPrincipals() {
        return Codegen.optional(this.awsServiceAccessPrincipals);
    }

    public Output<Optional<List<String>>> enabledPolicyTypes() {
        return Codegen.optional(this.enabledPolicyTypes);
    }

    public Output<Optional<String>> featureSet() {
        return Codegen.optional(this.featureSet);
    }

    public Output<String> masterAccountArn() {
        return this.masterAccountArn;
    }

    public Output<String> masterAccountEmail() {
        return this.masterAccountEmail;
    }

    public Output<String> masterAccountId() {
        return this.masterAccountId;
    }

    public Output<List<OrganizationNonMasterAccount>> nonMasterAccounts() {
        return this.nonMasterAccounts;
    }

    public Output<List<OrganizationRoot>> roots() {
        return this.roots;
    }

    public Organization(String name) {
        this(name, OrganizationArgs.Empty);
    }

    public Organization(String name, @Nullable OrganizationArgs args) {
        this(name, args, null);
    }

    public Organization(String name, @Nullable OrganizationArgs args, @Nullable CustomResourceOptions options) {
        super("aws:organizations/organization:Organization", name, (ResourceArgs)(args == null ? OrganizationArgs.Empty : args), Organization.makeResourceOptions(options, (Output<String>)Codegen.empty()));
    }

    private Organization(String name, Output<String> id, @Nullable OrganizationState state, @Nullable CustomResourceOptions options) {
        super("aws:organizations/organization:Organization", name, (ResourceArgs)state, Organization.makeResourceOptions(options, id));
    }

    private static CustomResourceOptions makeResourceOptions(@Nullable CustomResourceOptions options, @Nullable Output<String> id) {
        CustomResourceOptions defaultOptions = ((CustomResourceOptions.Builder)CustomResourceOptions.builder().version(Utilities.getVersion())).build();
        return CustomResourceOptions.merge((CustomResourceOptions)defaultOptions, (CustomResourceOptions)options, id);
    }

    public static Organization get(String name, Output<String> id, @Nullable OrganizationState state, @Nullable CustomResourceOptions options) {
        return new Organization(name, id, state, options);
    }
}

