/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.opsworks.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ApplicationSslConfiguration {
    private String certificate;
    @Nullable
    private String chain;
    private String privateKey;

    private ApplicationSslConfiguration() {
    }

    public String certificate() {
        return this.certificate;
    }

    public Optional<String> chain() {
        return Optional.ofNullable(this.chain);
    }

    public String privateKey() {
        return this.privateKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ApplicationSslConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String certificate;
        @Nullable
        private String chain;
        private String privateKey;

        public Builder() {
        }

        public Builder(ApplicationSslConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.certificate = defaults.certificate;
            this.chain = defaults.chain;
            this.privateKey = defaults.privateKey;
        }

        @CustomType.Setter
        public Builder certificate(String certificate) {
            this.certificate = Objects.requireNonNull(certificate);
            return this;
        }

        @CustomType.Setter
        public Builder chain(@Nullable String chain) {
            this.chain = chain;
            return this;
        }

        @CustomType.Setter
        public Builder privateKey(String privateKey) {
            this.privateKey = Objects.requireNonNull(privateKey);
            return this;
        }

        public ApplicationSslConfiguration build() {
            ApplicationSslConfiguration o = new ApplicationSslConfiguration();
            o.certificate = this.certificate;
            o.chain = this.chain;
            o.privateKey = this.privateKey;
            return o;
        }
    }
}

