/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.opensearch.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class VpcEndpointVpcOptions {
    @Nullable
    private List<String> availabilityZones;
    @Nullable
    private List<String> securityGroupIds;
    private List<String> subnetIds;
    @Nullable
    private String vpcId;

    private VpcEndpointVpcOptions() {
    }

    public List<String> availabilityZones() {
        return this.availabilityZones == null ? List.of() : this.availabilityZones;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds == null ? List.of() : this.securityGroupIds;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public Optional<String> vpcId() {
        return Optional.ofNullable(this.vpcId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(VpcEndpointVpcOptions defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<String> availabilityZones;
        @Nullable
        private List<String> securityGroupIds;
        private List<String> subnetIds;
        @Nullable
        private String vpcId;

        public Builder() {
        }

        public Builder(VpcEndpointVpcOptions defaults) {
            Objects.requireNonNull(defaults);
            this.availabilityZones = defaults.availabilityZones;
            this.securityGroupIds = defaults.securityGroupIds;
            this.subnetIds = defaults.subnetIds;
            this.vpcId = defaults.vpcId;
        }

        @CustomType.Setter
        public Builder availabilityZones(@Nullable List<String> availabilityZones) {
            this.availabilityZones = availabilityZones;
            return this;
        }

        public Builder availabilityZones(String ... availabilityZones) {
            return this.availabilityZones(List.of(availabilityZones));
        }

        @CustomType.Setter
        public Builder securityGroupIds(@Nullable List<String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        public Builder securityGroupIds(String ... securityGroupIds) {
            return this.securityGroupIds(List.of(securityGroupIds));
        }

        @CustomType.Setter
        public Builder subnetIds(List<String> subnetIds) {
            this.subnetIds = Objects.requireNonNull(subnetIds);
            return this;
        }

        public Builder subnetIds(String ... subnetIds) {
            return this.subnetIds(List.of(subnetIds));
        }

        @CustomType.Setter
        public Builder vpcId(@Nullable String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public VpcEndpointVpcOptions build() {
            VpcEndpointVpcOptions o = new VpcEndpointVpcOptions();
            o.availabilityZones = this.availabilityZones;
            o.securityGroupIds = this.securityGroupIds;
            o.subnetIds = this.subnetIds;
            o.vpcId = this.vpcId;
            return o;
        }
    }
}

