/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.networkmanager.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class VpcAttachmentOptions {
    @Nullable
    private Boolean applianceModeSupport;
    @Nullable
    private Boolean ipv6Support;

    private VpcAttachmentOptions() {
    }

    public Optional<Boolean> applianceModeSupport() {
        return Optional.ofNullable(this.applianceModeSupport);
    }

    public Optional<Boolean> ipv6Support() {
        return Optional.ofNullable(this.ipv6Support);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(VpcAttachmentOptions defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean applianceModeSupport;
        @Nullable
        private Boolean ipv6Support;

        public Builder() {
        }

        public Builder(VpcAttachmentOptions defaults) {
            Objects.requireNonNull(defaults);
            this.applianceModeSupport = defaults.applianceModeSupport;
            this.ipv6Support = defaults.ipv6Support;
        }

        @CustomType.Setter
        public Builder applianceModeSupport(@Nullable Boolean applianceModeSupport) {
            this.applianceModeSupport = applianceModeSupport;
            return this;
        }

        @CustomType.Setter
        public Builder ipv6Support(@Nullable Boolean ipv6Support) {
            this.ipv6Support = ipv6Support;
            return this;
        }

        public VpcAttachmentOptions build() {
            VpcAttachmentOptions o = new VpcAttachmentOptions();
            o.applianceModeSupport = this.applianceModeSupport;
            o.ipv6Support = this.ipv6Support;
            return o;
        }
    }
}

