/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.mskconnect;

import com.pulumi.aws.mskconnect.inputs.ConnectorCapacityArgs;
import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterArgs;
import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterClientAuthenticationArgs;
import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterEncryptionInTransitArgs;
import com.pulumi.aws.mskconnect.inputs.ConnectorLogDeliveryArgs;
import com.pulumi.aws.mskconnect.inputs.ConnectorPluginArgs;
import com.pulumi.aws.mskconnect.inputs.ConnectorWorkerConfigurationArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ConnectorArgs
extends ResourceArgs {
    public static final ConnectorArgs Empty = new ConnectorArgs();
    @Import(name="capacity", required=true)
    private Output<ConnectorCapacityArgs> capacity;
    @Import(name="connectorConfiguration", required=true)
    private Output<Map<String, String>> connectorConfiguration;
    @Import(name="description")
    @Nullable
    private Output<String> description;
    @Import(name="kafkaCluster", required=true)
    private Output<ConnectorKafkaClusterArgs> kafkaCluster;
    @Import(name="kafkaClusterClientAuthentication", required=true)
    private Output<ConnectorKafkaClusterClientAuthenticationArgs> kafkaClusterClientAuthentication;
    @Import(name="kafkaClusterEncryptionInTransit", required=true)
    private Output<ConnectorKafkaClusterEncryptionInTransitArgs> kafkaClusterEncryptionInTransit;
    @Import(name="kafkaconnectVersion", required=true)
    private Output<String> kafkaconnectVersion;
    @Import(name="logDelivery")
    @Nullable
    private Output<ConnectorLogDeliveryArgs> logDelivery;
    @Import(name="name")
    @Nullable
    private Output<String> name;
    @Import(name="plugins", required=true)
    private Output<List<ConnectorPluginArgs>> plugins;
    @Import(name="serviceExecutionRoleArn", required=true)
    private Output<String> serviceExecutionRoleArn;
    @Import(name="workerConfiguration")
    @Nullable
    private Output<ConnectorWorkerConfigurationArgs> workerConfiguration;

    public Output<ConnectorCapacityArgs> capacity() {
        return this.capacity;
    }

    public Output<Map<String, String>> connectorConfiguration() {
        return this.connectorConfiguration;
    }

    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    public Output<ConnectorKafkaClusterArgs> kafkaCluster() {
        return this.kafkaCluster;
    }

    public Output<ConnectorKafkaClusterClientAuthenticationArgs> kafkaClusterClientAuthentication() {
        return this.kafkaClusterClientAuthentication;
    }

    public Output<ConnectorKafkaClusterEncryptionInTransitArgs> kafkaClusterEncryptionInTransit() {
        return this.kafkaClusterEncryptionInTransit;
    }

    public Output<String> kafkaconnectVersion() {
        return this.kafkaconnectVersion;
    }

    public Optional<Output<ConnectorLogDeliveryArgs>> logDelivery() {
        return Optional.ofNullable(this.logDelivery);
    }

    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    public Output<List<ConnectorPluginArgs>> plugins() {
        return this.plugins;
    }

    public Output<String> serviceExecutionRoleArn() {
        return this.serviceExecutionRoleArn;
    }

    public Optional<Output<ConnectorWorkerConfigurationArgs>> workerConfiguration() {
        return Optional.ofNullable(this.workerConfiguration);
    }

    private ConnectorArgs() {
    }

    private ConnectorArgs(ConnectorArgs $) {
        this.capacity = $.capacity;
        this.connectorConfiguration = $.connectorConfiguration;
        this.description = $.description;
        this.kafkaCluster = $.kafkaCluster;
        this.kafkaClusterClientAuthentication = $.kafkaClusterClientAuthentication;
        this.kafkaClusterEncryptionInTransit = $.kafkaClusterEncryptionInTransit;
        this.kafkaconnectVersion = $.kafkaconnectVersion;
        this.logDelivery = $.logDelivery;
        this.name = $.name;
        this.plugins = $.plugins;
        this.serviceExecutionRoleArn = $.serviceExecutionRoleArn;
        this.workerConfiguration = $.workerConfiguration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ConnectorArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ConnectorArgs $;

        public Builder() {
            this.$ = new ConnectorArgs();
        }

        public Builder(ConnectorArgs defaults) {
            this.$ = new ConnectorArgs(Objects.requireNonNull(defaults));
        }

        public Builder capacity(Output<ConnectorCapacityArgs> capacity) {
            this.$.capacity = capacity;
            return this;
        }

        public Builder capacity(ConnectorCapacityArgs capacity) {
            return this.capacity((Output<ConnectorCapacityArgs>)Output.of((Object)((Object)capacity)));
        }

        public Builder connectorConfiguration(Output<Map<String, String>> connectorConfiguration) {
            this.$.connectorConfiguration = connectorConfiguration;
            return this;
        }

        public Builder connectorConfiguration(Map<String, String> connectorConfiguration) {
            return this.connectorConfiguration((Output<Map<String, String>>)Output.of(connectorConfiguration));
        }

        public Builder description(@Nullable Output<String> description) {
            this.$.description = description;
            return this;
        }

        public Builder description(String description) {
            return this.description((Output<String>)Output.of((Object)description));
        }

        public Builder kafkaCluster(Output<ConnectorKafkaClusterArgs> kafkaCluster) {
            this.$.kafkaCluster = kafkaCluster;
            return this;
        }

        public Builder kafkaCluster(ConnectorKafkaClusterArgs kafkaCluster) {
            return this.kafkaCluster((Output<ConnectorKafkaClusterArgs>)Output.of((Object)((Object)kafkaCluster)));
        }

        public Builder kafkaClusterClientAuthentication(Output<ConnectorKafkaClusterClientAuthenticationArgs> kafkaClusterClientAuthentication) {
            this.$.kafkaClusterClientAuthentication = kafkaClusterClientAuthentication;
            return this;
        }

        public Builder kafkaClusterClientAuthentication(ConnectorKafkaClusterClientAuthenticationArgs kafkaClusterClientAuthentication) {
            return this.kafkaClusterClientAuthentication((Output<ConnectorKafkaClusterClientAuthenticationArgs>)Output.of((Object)((Object)kafkaClusterClientAuthentication)));
        }

        public Builder kafkaClusterEncryptionInTransit(Output<ConnectorKafkaClusterEncryptionInTransitArgs> kafkaClusterEncryptionInTransit) {
            this.$.kafkaClusterEncryptionInTransit = kafkaClusterEncryptionInTransit;
            return this;
        }

        public Builder kafkaClusterEncryptionInTransit(ConnectorKafkaClusterEncryptionInTransitArgs kafkaClusterEncryptionInTransit) {
            return this.kafkaClusterEncryptionInTransit((Output<ConnectorKafkaClusterEncryptionInTransitArgs>)Output.of((Object)((Object)kafkaClusterEncryptionInTransit)));
        }

        public Builder kafkaconnectVersion(Output<String> kafkaconnectVersion) {
            this.$.kafkaconnectVersion = kafkaconnectVersion;
            return this;
        }

        public Builder kafkaconnectVersion(String kafkaconnectVersion) {
            return this.kafkaconnectVersion((Output<String>)Output.of((Object)kafkaconnectVersion));
        }

        public Builder logDelivery(@Nullable Output<ConnectorLogDeliveryArgs> logDelivery) {
            this.$.logDelivery = logDelivery;
            return this;
        }

        public Builder logDelivery(ConnectorLogDeliveryArgs logDelivery) {
            return this.logDelivery((Output<ConnectorLogDeliveryArgs>)Output.of((Object)((Object)logDelivery)));
        }

        public Builder name(@Nullable Output<String> name) {
            this.$.name = name;
            return this;
        }

        public Builder name(String name) {
            return this.name((Output<String>)Output.of((Object)name));
        }

        public Builder plugins(Output<List<ConnectorPluginArgs>> plugins) {
            this.$.plugins = plugins;
            return this;
        }

        public Builder plugins(List<ConnectorPluginArgs> plugins) {
            return this.plugins((Output<List<ConnectorPluginArgs>>)Output.of(plugins));
        }

        public Builder plugins(ConnectorPluginArgs ... plugins) {
            return this.plugins(List.of(plugins));
        }

        public Builder serviceExecutionRoleArn(Output<String> serviceExecutionRoleArn) {
            this.$.serviceExecutionRoleArn = serviceExecutionRoleArn;
            return this;
        }

        public Builder serviceExecutionRoleArn(String serviceExecutionRoleArn) {
            return this.serviceExecutionRoleArn((Output<String>)Output.of((Object)serviceExecutionRoleArn));
        }

        public Builder workerConfiguration(@Nullable Output<ConnectorWorkerConfigurationArgs> workerConfiguration) {
            this.$.workerConfiguration = workerConfiguration;
            return this;
        }

        public Builder workerConfiguration(ConnectorWorkerConfigurationArgs workerConfiguration) {
            return this.workerConfiguration((Output<ConnectorWorkerConfigurationArgs>)Output.of((Object)((Object)workerConfiguration)));
        }

        public ConnectorArgs build() {
            this.$.capacity = Objects.requireNonNull(this.$.capacity, "expected parameter 'capacity' to be non-null");
            this.$.connectorConfiguration = Objects.requireNonNull(this.$.connectorConfiguration, "expected parameter 'connectorConfiguration' to be non-null");
            this.$.kafkaCluster = Objects.requireNonNull(this.$.kafkaCluster, "expected parameter 'kafkaCluster' to be non-null");
            this.$.kafkaClusterClientAuthentication = Objects.requireNonNull(this.$.kafkaClusterClientAuthentication, "expected parameter 'kafkaClusterClientAuthentication' to be non-null");
            this.$.kafkaClusterEncryptionInTransit = Objects.requireNonNull(this.$.kafkaClusterEncryptionInTransit, "expected parameter 'kafkaClusterEncryptionInTransit' to be non-null");
            this.$.kafkaconnectVersion = Objects.requireNonNull(this.$.kafkaconnectVersion, "expected parameter 'kafkaconnectVersion' to be non-null");
            this.$.plugins = Objects.requireNonNull(this.$.plugins, "expected parameter 'plugins' to be non-null");
            this.$.serviceExecutionRoleArn = Objects.requireNonNull(this.$.serviceExecutionRoleArn, "expected parameter 'serviceExecutionRoleArn' to be non-null");
            return this.$;
        }
    }
}

