/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.mq.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class BrokerUser {
    @Nullable
    private Boolean consoleAccess;
    @Nullable
    private List<String> groups;
    private String password;
    @Nullable
    private Boolean replicationUser;
    private String username;

    private BrokerUser() {
    }

    public Optional<Boolean> consoleAccess() {
        return Optional.ofNullable(this.consoleAccess);
    }

    public List<String> groups() {
        return this.groups == null ? List.of() : this.groups;
    }

    public String password() {
        return this.password;
    }

    public Optional<Boolean> replicationUser() {
        return Optional.ofNullable(this.replicationUser);
    }

    public String username() {
        return this.username;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BrokerUser defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean consoleAccess;
        @Nullable
        private List<String> groups;
        private String password;
        @Nullable
        private Boolean replicationUser;
        private String username;

        public Builder() {
        }

        public Builder(BrokerUser defaults) {
            Objects.requireNonNull(defaults);
            this.consoleAccess = defaults.consoleAccess;
            this.groups = defaults.groups;
            this.password = defaults.password;
            this.replicationUser = defaults.replicationUser;
            this.username = defaults.username;
        }

        @CustomType.Setter
        public Builder consoleAccess(@Nullable Boolean consoleAccess) {
            this.consoleAccess = consoleAccess;
            return this;
        }

        @CustomType.Setter
        public Builder groups(@Nullable List<String> groups) {
            this.groups = groups;
            return this;
        }

        public Builder groups(String ... groups) {
            return this.groups(List.of(groups));
        }

        @CustomType.Setter
        public Builder password(String password) {
            this.password = Objects.requireNonNull(password);
            return this;
        }

        @CustomType.Setter
        public Builder replicationUser(@Nullable Boolean replicationUser) {
            this.replicationUser = replicationUser;
            return this;
        }

        @CustomType.Setter
        public Builder username(String username) {
            this.username = Objects.requireNonNull(username);
            return this;
        }

        public BrokerUser build() {
            BrokerUser o = new BrokerUser();
            o.consoleAccess = this.consoleAccess;
            o.groups = this.groups;
            o.password = this.password;
            o.replicationUser = this.replicationUser;
            o.username = this.username;
            return o;
        }
    }
}

