/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.memorydb.outputs;

import com.pulumi.aws.memorydb.outputs.ClusterShardNode;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ClusterShard {
    @Nullable
    private String name;
    @Nullable
    private List<ClusterShardNode> nodes;
    @Nullable
    private Integer numNodes;
    @Nullable
    private String slots;

    private ClusterShard() {
    }

    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    public List<ClusterShardNode> nodes() {
        return this.nodes == null ? List.of() : this.nodes;
    }

    public Optional<Integer> numNodes() {
        return Optional.ofNullable(this.numNodes);
    }

    public Optional<String> slots() {
        return Optional.ofNullable(this.slots);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterShard defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String name;
        @Nullable
        private List<ClusterShardNode> nodes;
        @Nullable
        private Integer numNodes;
        @Nullable
        private String slots;

        public Builder() {
        }

        public Builder(ClusterShard defaults) {
            Objects.requireNonNull(defaults);
            this.name = defaults.name;
            this.nodes = defaults.nodes;
            this.numNodes = defaults.numNodes;
            this.slots = defaults.slots;
        }

        @CustomType.Setter
        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder nodes(@Nullable List<ClusterShardNode> nodes) {
            this.nodes = nodes;
            return this;
        }

        public Builder nodes(ClusterShardNode ... nodes) {
            return this.nodes(List.of(nodes));
        }

        @CustomType.Setter
        public Builder numNodes(@Nullable Integer numNodes) {
            this.numNodes = numNodes;
            return this;
        }

        @CustomType.Setter
        public Builder slots(@Nullable String slots) {
            this.slots = slots;
            return this;
        }

        public ClusterShard build() {
            ClusterShard o = new ClusterShard();
            o.name = this.name;
            o.nodes = this.nodes;
            o.numNodes = this.numNodes;
            o.slots = this.slots;
            return o;
        }
    }
}

