/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.lambda.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class FunctionImageConfig {
    @Nullable
    private List<String> commands;
    @Nullable
    private List<String> entryPoints;
    @Nullable
    private String workingDirectory;

    private FunctionImageConfig() {
    }

    public List<String> commands() {
        return this.commands == null ? List.of() : this.commands;
    }

    public List<String> entryPoints() {
        return this.entryPoints == null ? List.of() : this.entryPoints;
    }

    public Optional<String> workingDirectory() {
        return Optional.ofNullable(this.workingDirectory);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FunctionImageConfig defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<String> commands;
        @Nullable
        private List<String> entryPoints;
        @Nullable
        private String workingDirectory;

        public Builder() {
        }

        public Builder(FunctionImageConfig defaults) {
            Objects.requireNonNull(defaults);
            this.commands = defaults.commands;
            this.entryPoints = defaults.entryPoints;
            this.workingDirectory = defaults.workingDirectory;
        }

        @CustomType.Setter
        public Builder commands(@Nullable List<String> commands) {
            this.commands = commands;
            return this;
        }

        public Builder commands(String ... commands) {
            return this.commands(List.of(commands));
        }

        @CustomType.Setter
        public Builder entryPoints(@Nullable List<String> entryPoints) {
            this.entryPoints = entryPoints;
            return this;
        }

        public Builder entryPoints(String ... entryPoints) {
            return this.entryPoints(List.of(entryPoints));
        }

        @CustomType.Setter
        public Builder workingDirectory(@Nullable String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public FunctionImageConfig build() {
            FunctionImageConfig o = new FunctionImageConfig();
            o.commands = this.commands;
            o.entryPoints = this.entryPoints;
            o.workingDirectory = this.workingDirectory;
            return o;
        }
    }
}

