/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.lambda.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;

@CustomType
public final class FunctionFileSystemConfig {
    private String arn;
    private String localMountPath;

    private FunctionFileSystemConfig() {
    }

    public String arn() {
        return this.arn;
    }

    public String localMountPath() {
        return this.localMountPath;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FunctionFileSystemConfig defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String arn;
        private String localMountPath;

        public Builder() {
        }

        public Builder(FunctionFileSystemConfig defaults) {
            Objects.requireNonNull(defaults);
            this.arn = defaults.arn;
            this.localMountPath = defaults.localMountPath;
        }

        @CustomType.Setter
        public Builder arn(String arn) {
            this.arn = Objects.requireNonNull(arn);
            return this;
        }

        @CustomType.Setter
        public Builder localMountPath(String localMountPath) {
            this.localMountPath = Objects.requireNonNull(localMountPath);
            return this;
        }

        public FunctionFileSystemConfig build() {
            FunctionFileSystemConfig o = new FunctionFileSystemConfig();
            o.arn = this.arn;
            o.localMountPath = this.localMountPath;
            return o;
        }
    }
}

