/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.kms.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GetSecretsSecret {
    @Nullable
    private Map<String, String> context;
    @Nullable
    private String encryptionAlgorithm;
    @Nullable
    private List<String> grantTokens;
    @Nullable
    private String keyId;
    private String name;
    private String payload;

    private GetSecretsSecret() {
    }

    public Map<String, String> context() {
        return this.context == null ? Map.of() : this.context;
    }

    public Optional<String> encryptionAlgorithm() {
        return Optional.ofNullable(this.encryptionAlgorithm);
    }

    public List<String> grantTokens() {
        return this.grantTokens == null ? List.of() : this.grantTokens;
    }

    public Optional<String> keyId() {
        return Optional.ofNullable(this.keyId);
    }

    public String name() {
        return this.name;
    }

    public String payload() {
        return this.payload;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GetSecretsSecret defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Map<String, String> context;
        @Nullable
        private String encryptionAlgorithm;
        @Nullable
        private List<String> grantTokens;
        @Nullable
        private String keyId;
        private String name;
        private String payload;

        public Builder() {
        }

        public Builder(GetSecretsSecret defaults) {
            Objects.requireNonNull(defaults);
            this.context = defaults.context;
            this.encryptionAlgorithm = defaults.encryptionAlgorithm;
            this.grantTokens = defaults.grantTokens;
            this.keyId = defaults.keyId;
            this.name = defaults.name;
            this.payload = defaults.payload;
        }

        @CustomType.Setter
        public Builder context(@Nullable Map<String, String> context) {
            this.context = context;
            return this;
        }

        @CustomType.Setter
        public Builder encryptionAlgorithm(@Nullable String encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            return this;
        }

        @CustomType.Setter
        public Builder grantTokens(@Nullable List<String> grantTokens) {
            this.grantTokens = grantTokens;
            return this;
        }

        public Builder grantTokens(String ... grantTokens) {
            return this.grantTokens(List.of(grantTokens));
        }

        @CustomType.Setter
        public Builder keyId(@Nullable String keyId) {
            this.keyId = keyId;
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        @CustomType.Setter
        public Builder payload(String payload) {
            this.payload = Objects.requireNonNull(payload);
            return this;
        }

        public GetSecretsSecret build() {
            GetSecretsSecret o = new GetSecretsSecret();
            o.context = this.context;
            o.encryptionAlgorithm = this.encryptionAlgorithm;
            o.grantTokens = this.grantTokens;
            o.keyId = this.keyId;
            o.name = this.name;
            o.payload = this.payload;
            return o;
        }
    }
}

