/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.kendra.outputs;

import com.pulumi.aws.kendra.outputs.DataSourceConfigurationS3Configuration;
import com.pulumi.aws.kendra.outputs.DataSourceConfigurationWebCrawlerConfiguration;
import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class DataSourceConfiguration {
    @Nullable
    private DataSourceConfigurationS3Configuration s3Configuration;
    @Nullable
    private DataSourceConfigurationWebCrawlerConfiguration webCrawlerConfiguration;

    private DataSourceConfiguration() {
    }

    public Optional<DataSourceConfigurationS3Configuration> s3Configuration() {
        return Optional.ofNullable(this.s3Configuration);
    }

    public Optional<DataSourceConfigurationWebCrawlerConfiguration> webCrawlerConfiguration() {
        return Optional.ofNullable(this.webCrawlerConfiguration);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DataSourceConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private DataSourceConfigurationS3Configuration s3Configuration;
        @Nullable
        private DataSourceConfigurationWebCrawlerConfiguration webCrawlerConfiguration;

        public Builder() {
        }

        public Builder(DataSourceConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.s3Configuration = defaults.s3Configuration;
            this.webCrawlerConfiguration = defaults.webCrawlerConfiguration;
        }

        @CustomType.Setter
        public Builder s3Configuration(@Nullable DataSourceConfigurationS3Configuration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        @CustomType.Setter
        public Builder webCrawlerConfiguration(@Nullable DataSourceConfigurationWebCrawlerConfiguration webCrawlerConfiguration) {
            this.webCrawlerConfiguration = webCrawlerConfiguration;
            return this;
        }

        public DataSourceConfiguration build() {
            DataSourceConfiguration o = new DataSourceConfiguration();
            o.s3Configuration = this.s3Configuration;
            o.webCrawlerConfiguration = this.webCrawlerConfiguration;
            return o;
        }
    }
}

