/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.iot.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class TopicRuleKafka {
    private Map<String, String> clientProperties;
    private String destinationArn;
    @Nullable
    private String key;
    @Nullable
    private String partition;
    private String topic;

    private TopicRuleKafka() {
    }

    public Map<String, String> clientProperties() {
        return this.clientProperties;
    }

    public String destinationArn() {
        return this.destinationArn;
    }

    public Optional<String> key() {
        return Optional.ofNullable(this.key);
    }

    public Optional<String> partition() {
        return Optional.ofNullable(this.partition);
    }

    public String topic() {
        return this.topic;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TopicRuleKafka defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private Map<String, String> clientProperties;
        private String destinationArn;
        @Nullable
        private String key;
        @Nullable
        private String partition;
        private String topic;

        public Builder() {
        }

        public Builder(TopicRuleKafka defaults) {
            Objects.requireNonNull(defaults);
            this.clientProperties = defaults.clientProperties;
            this.destinationArn = defaults.destinationArn;
            this.key = defaults.key;
            this.partition = defaults.partition;
            this.topic = defaults.topic;
        }

        @CustomType.Setter
        public Builder clientProperties(Map<String, String> clientProperties) {
            this.clientProperties = Objects.requireNonNull(clientProperties);
            return this;
        }

        @CustomType.Setter
        public Builder destinationArn(String destinationArn) {
            this.destinationArn = Objects.requireNonNull(destinationArn);
            return this;
        }

        @CustomType.Setter
        public Builder key(@Nullable String key) {
            this.key = key;
            return this;
        }

        @CustomType.Setter
        public Builder partition(@Nullable String partition) {
            this.partition = partition;
            return this;
        }

        @CustomType.Setter
        public Builder topic(String topic) {
            this.topic = Objects.requireNonNull(topic);
            return this;
        }

        public TopicRuleKafka build() {
            TopicRuleKafka o = new TopicRuleKafka();
            o.clientProperties = this.clientProperties;
            o.destinationArn = this.destinationArn;
            o.key = this.key;
            o.partition = this.partition;
            o.topic = this.topic;
            return o;
        }
    }
}

