/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.guardduty.outputs;

import com.pulumi.aws.guardduty.outputs.DetectorDatasourcesKubernetes;
import com.pulumi.aws.guardduty.outputs.DetectorDatasourcesMalwareProtection;
import com.pulumi.aws.guardduty.outputs.DetectorDatasourcesS3Logs;
import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class DetectorDatasources {
    @Nullable
    private DetectorDatasourcesKubernetes kubernetes;
    @Nullable
    private DetectorDatasourcesMalwareProtection malwareProtection;
    @Nullable
    private DetectorDatasourcesS3Logs s3Logs;

    private DetectorDatasources() {
    }

    public Optional<DetectorDatasourcesKubernetes> kubernetes() {
        return Optional.ofNullable(this.kubernetes);
    }

    public Optional<DetectorDatasourcesMalwareProtection> malwareProtection() {
        return Optional.ofNullable(this.malwareProtection);
    }

    public Optional<DetectorDatasourcesS3Logs> s3Logs() {
        return Optional.ofNullable(this.s3Logs);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DetectorDatasources defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private DetectorDatasourcesKubernetes kubernetes;
        @Nullable
        private DetectorDatasourcesMalwareProtection malwareProtection;
        @Nullable
        private DetectorDatasourcesS3Logs s3Logs;

        public Builder() {
        }

        public Builder(DetectorDatasources defaults) {
            Objects.requireNonNull(defaults);
            this.kubernetes = defaults.kubernetes;
            this.malwareProtection = defaults.malwareProtection;
            this.s3Logs = defaults.s3Logs;
        }

        @CustomType.Setter
        public Builder kubernetes(@Nullable DetectorDatasourcesKubernetes kubernetes) {
            this.kubernetes = kubernetes;
            return this;
        }

        @CustomType.Setter
        public Builder malwareProtection(@Nullable DetectorDatasourcesMalwareProtection malwareProtection) {
            this.malwareProtection = malwareProtection;
            return this;
        }

        @CustomType.Setter
        public Builder s3Logs(@Nullable DetectorDatasourcesS3Logs s3Logs) {
            this.s3Logs = s3Logs;
            return this;
        }

        public DetectorDatasources build() {
            DetectorDatasources o = new DetectorDatasources();
            o.kubernetes = this.kubernetes;
            o.malwareProtection = this.malwareProtection;
            o.s3Logs = this.s3Logs;
            return o;
        }
    }
}

