/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.grafana.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;

@CustomType
public final class WorkspaceNetworkAccessControl {
    private List<String> prefixListIds;
    private List<String> vpceIds;

    private WorkspaceNetworkAccessControl() {
    }

    public List<String> prefixListIds() {
        return this.prefixListIds;
    }

    public List<String> vpceIds() {
        return this.vpceIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(WorkspaceNetworkAccessControl defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<String> prefixListIds;
        private List<String> vpceIds;

        public Builder() {
        }

        public Builder(WorkspaceNetworkAccessControl defaults) {
            Objects.requireNonNull(defaults);
            this.prefixListIds = defaults.prefixListIds;
            this.vpceIds = defaults.vpceIds;
        }

        @CustomType.Setter
        public Builder prefixListIds(List<String> prefixListIds) {
            this.prefixListIds = Objects.requireNonNull(prefixListIds);
            return this;
        }

        public Builder prefixListIds(String ... prefixListIds) {
            return this.prefixListIds(List.of(prefixListIds));
        }

        @CustomType.Setter
        public Builder vpceIds(List<String> vpceIds) {
            this.vpceIds = Objects.requireNonNull(vpceIds);
            return this;
        }

        public Builder vpceIds(String ... vpceIds) {
            return this.vpceIds(List.of(vpceIds));
        }

        public WorkspaceNetworkAccessControl build() {
            WorkspaceNetworkAccessControl o = new WorkspaceNetworkAccessControl();
            o.prefixListIds = this.prefixListIds;
            o.vpceIds = this.vpceIds;
            return o;
        }
    }
}

