/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.glue.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class CrawlerS3Target {
    @Nullable
    private String connectionName;
    @Nullable
    private String dlqEventQueueArn;
    @Nullable
    private String eventQueueArn;
    @Nullable
    private List<String> exclusions;
    private String path;
    @Nullable
    private Integer sampleSize;

    private CrawlerS3Target() {
    }

    public Optional<String> connectionName() {
        return Optional.ofNullable(this.connectionName);
    }

    public Optional<String> dlqEventQueueArn() {
        return Optional.ofNullable(this.dlqEventQueueArn);
    }

    public Optional<String> eventQueueArn() {
        return Optional.ofNullable(this.eventQueueArn);
    }

    public List<String> exclusions() {
        return this.exclusions == null ? List.of() : this.exclusions;
    }

    public String path() {
        return this.path;
    }

    public Optional<Integer> sampleSize() {
        return Optional.ofNullable(this.sampleSize);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CrawlerS3Target defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String connectionName;
        @Nullable
        private String dlqEventQueueArn;
        @Nullable
        private String eventQueueArn;
        @Nullable
        private List<String> exclusions;
        private String path;
        @Nullable
        private Integer sampleSize;

        public Builder() {
        }

        public Builder(CrawlerS3Target defaults) {
            Objects.requireNonNull(defaults);
            this.connectionName = defaults.connectionName;
            this.dlqEventQueueArn = defaults.dlqEventQueueArn;
            this.eventQueueArn = defaults.eventQueueArn;
            this.exclusions = defaults.exclusions;
            this.path = defaults.path;
            this.sampleSize = defaults.sampleSize;
        }

        @CustomType.Setter
        public Builder connectionName(@Nullable String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        @CustomType.Setter
        public Builder dlqEventQueueArn(@Nullable String dlqEventQueueArn) {
            this.dlqEventQueueArn = dlqEventQueueArn;
            return this;
        }

        @CustomType.Setter
        public Builder eventQueueArn(@Nullable String eventQueueArn) {
            this.eventQueueArn = eventQueueArn;
            return this;
        }

        @CustomType.Setter
        public Builder exclusions(@Nullable List<String> exclusions) {
            this.exclusions = exclusions;
            return this;
        }

        public Builder exclusions(String ... exclusions) {
            return this.exclusions(List.of(exclusions));
        }

        @CustomType.Setter
        public Builder path(String path) {
            this.path = Objects.requireNonNull(path);
            return this;
        }

        @CustomType.Setter
        public Builder sampleSize(@Nullable Integer sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        public CrawlerS3Target build() {
            CrawlerS3Target o = new CrawlerS3Target();
            o.connectionName = this.connectionName;
            o.dlqEventQueueArn = this.dlqEventQueueArn;
            o.eventQueueArn = this.eventQueueArn;
            o.exclusions = this.exclusions;
            o.path = this.path;
            o.sampleSize = this.sampleSize;
            return o;
        }
    }
}

