/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.glue.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class CrawlerHudiTarget {
    @Nullable
    private String connectionName;
    @Nullable
    private List<String> exclusions;
    private Integer maximumTraversalDepth;
    private List<String> paths;

    private CrawlerHudiTarget() {
    }

    public Optional<String> connectionName() {
        return Optional.ofNullable(this.connectionName);
    }

    public List<String> exclusions() {
        return this.exclusions == null ? List.of() : this.exclusions;
    }

    public Integer maximumTraversalDepth() {
        return this.maximumTraversalDepth;
    }

    public List<String> paths() {
        return this.paths;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CrawlerHudiTarget defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String connectionName;
        @Nullable
        private List<String> exclusions;
        private Integer maximumTraversalDepth;
        private List<String> paths;

        public Builder() {
        }

        public Builder(CrawlerHudiTarget defaults) {
            Objects.requireNonNull(defaults);
            this.connectionName = defaults.connectionName;
            this.exclusions = defaults.exclusions;
            this.maximumTraversalDepth = defaults.maximumTraversalDepth;
            this.paths = defaults.paths;
        }

        @CustomType.Setter
        public Builder connectionName(@Nullable String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        @CustomType.Setter
        public Builder exclusions(@Nullable List<String> exclusions) {
            this.exclusions = exclusions;
            return this;
        }

        public Builder exclusions(String ... exclusions) {
            return this.exclusions(List.of(exclusions));
        }

        @CustomType.Setter
        public Builder maximumTraversalDepth(Integer maximumTraversalDepth) {
            this.maximumTraversalDepth = Objects.requireNonNull(maximumTraversalDepth);
            return this;
        }

        @CustomType.Setter
        public Builder paths(List<String> paths) {
            this.paths = Objects.requireNonNull(paths);
            return this;
        }

        public Builder paths(String ... paths) {
            return this.paths(List.of(paths));
        }

        public CrawlerHudiTarget build() {
            CrawlerHudiTarget o = new CrawlerHudiTarget();
            o.connectionName = this.connectionName;
            o.exclusions = this.exclusions;
            o.maximumTraversalDepth = this.maximumTraversalDepth;
            o.paths = this.paths;
            return o;
        }
    }
}

