/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.glue.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class CrawlerDynamodbTarget {
    private String path;
    @Nullable
    private Boolean scanAll;
    @Nullable
    private Double scanRate;

    private CrawlerDynamodbTarget() {
    }

    public String path() {
        return this.path;
    }

    public Optional<Boolean> scanAll() {
        return Optional.ofNullable(this.scanAll);
    }

    public Optional<Double> scanRate() {
        return Optional.ofNullable(this.scanRate);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CrawlerDynamodbTarget defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String path;
        @Nullable
        private Boolean scanAll;
        @Nullable
        private Double scanRate;

        public Builder() {
        }

        public Builder(CrawlerDynamodbTarget defaults) {
            Objects.requireNonNull(defaults);
            this.path = defaults.path;
            this.scanAll = defaults.scanAll;
            this.scanRate = defaults.scanRate;
        }

        @CustomType.Setter
        public Builder path(String path) {
            this.path = Objects.requireNonNull(path);
            return this;
        }

        @CustomType.Setter
        public Builder scanAll(@Nullable Boolean scanAll) {
            this.scanAll = scanAll;
            return this;
        }

        @CustomType.Setter
        public Builder scanRate(@Nullable Double scanRate) {
            this.scanRate = scanRate;
            return this;
        }

        public CrawlerDynamodbTarget build() {
            CrawlerDynamodbTarget o = new CrawlerDynamodbTarget();
            o.path = this.path;
            o.scanAll = this.scanAll;
            o.scanRate = this.scanRate;
            return o;
        }
    }
}

