/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.glue;

import com.pulumi.aws.glue.inputs.JobCommandArgs;
import com.pulumi.aws.glue.inputs.JobExecutionPropertyArgs;
import com.pulumi.aws.glue.inputs.JobNotificationPropertyArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class JobArgs
extends ResourceArgs {
    public static final JobArgs Empty = new JobArgs();
    @Import(name="command", required=true)
    private Output<JobCommandArgs> command;
    @Import(name="connections")
    @Nullable
    private Output<List<String>> connections;
    @Import(name="defaultArguments")
    @Nullable
    private Output<Map<String, String>> defaultArguments;
    @Import(name="description")
    @Nullable
    private Output<String> description;
    @Import(name="executionClass")
    @Nullable
    private Output<String> executionClass;
    @Import(name="executionProperty")
    @Nullable
    private Output<JobExecutionPropertyArgs> executionProperty;
    @Import(name="glueVersion")
    @Nullable
    private Output<String> glueVersion;
    @Import(name="maxCapacity")
    @Nullable
    private Output<Double> maxCapacity;
    @Import(name="maxRetries")
    @Nullable
    private Output<Integer> maxRetries;
    @Import(name="name")
    @Nullable
    private Output<String> name;
    @Import(name="nonOverridableArguments")
    @Nullable
    private Output<Map<String, String>> nonOverridableArguments;
    @Import(name="notificationProperty")
    @Nullable
    private Output<JobNotificationPropertyArgs> notificationProperty;
    @Import(name="numberOfWorkers")
    @Nullable
    private Output<Integer> numberOfWorkers;
    @Import(name="roleArn", required=true)
    private Output<String> roleArn;
    @Import(name="securityConfiguration")
    @Nullable
    private Output<String> securityConfiguration;
    @Import(name="tags")
    @Nullable
    private Output<Map<String, String>> tags;
    @Import(name="timeout")
    @Nullable
    private Output<Integer> timeout;
    @Import(name="workerType")
    @Nullable
    private Output<String> workerType;

    public Output<JobCommandArgs> command() {
        return this.command;
    }

    public Optional<Output<List<String>>> connections() {
        return Optional.ofNullable(this.connections);
    }

    public Optional<Output<Map<String, String>>> defaultArguments() {
        return Optional.ofNullable(this.defaultArguments);
    }

    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    public Optional<Output<String>> executionClass() {
        return Optional.ofNullable(this.executionClass);
    }

    public Optional<Output<JobExecutionPropertyArgs>> executionProperty() {
        return Optional.ofNullable(this.executionProperty);
    }

    public Optional<Output<String>> glueVersion() {
        return Optional.ofNullable(this.glueVersion);
    }

    public Optional<Output<Double>> maxCapacity() {
        return Optional.ofNullable(this.maxCapacity);
    }

    public Optional<Output<Integer>> maxRetries() {
        return Optional.ofNullable(this.maxRetries);
    }

    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    public Optional<Output<Map<String, String>>> nonOverridableArguments() {
        return Optional.ofNullable(this.nonOverridableArguments);
    }

    public Optional<Output<JobNotificationPropertyArgs>> notificationProperty() {
        return Optional.ofNullable(this.notificationProperty);
    }

    public Optional<Output<Integer>> numberOfWorkers() {
        return Optional.ofNullable(this.numberOfWorkers);
    }

    public Output<String> roleArn() {
        return this.roleArn;
    }

    public Optional<Output<String>> securityConfiguration() {
        return Optional.ofNullable(this.securityConfiguration);
    }

    public Optional<Output<Map<String, String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    public Optional<Output<Integer>> timeout() {
        return Optional.ofNullable(this.timeout);
    }

    public Optional<Output<String>> workerType() {
        return Optional.ofNullable(this.workerType);
    }

    private JobArgs() {
    }

    private JobArgs(JobArgs $) {
        this.command = $.command;
        this.connections = $.connections;
        this.defaultArguments = $.defaultArguments;
        this.description = $.description;
        this.executionClass = $.executionClass;
        this.executionProperty = $.executionProperty;
        this.glueVersion = $.glueVersion;
        this.maxCapacity = $.maxCapacity;
        this.maxRetries = $.maxRetries;
        this.name = $.name;
        this.nonOverridableArguments = $.nonOverridableArguments;
        this.notificationProperty = $.notificationProperty;
        this.numberOfWorkers = $.numberOfWorkers;
        this.roleArn = $.roleArn;
        this.securityConfiguration = $.securityConfiguration;
        this.tags = $.tags;
        this.timeout = $.timeout;
        this.workerType = $.workerType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(JobArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private JobArgs $;

        public Builder() {
            this.$ = new JobArgs();
        }

        public Builder(JobArgs defaults) {
            this.$ = new JobArgs(Objects.requireNonNull(defaults));
        }

        public Builder command(Output<JobCommandArgs> command) {
            this.$.command = command;
            return this;
        }

        public Builder command(JobCommandArgs command) {
            return this.command((Output<JobCommandArgs>)Output.of((Object)((Object)command)));
        }

        public Builder connections(@Nullable Output<List<String>> connections) {
            this.$.connections = connections;
            return this;
        }

        public Builder connections(List<String> connections) {
            return this.connections((Output<List<String>>)Output.of(connections));
        }

        public Builder connections(String ... connections) {
            return this.connections(List.of(connections));
        }

        public Builder defaultArguments(@Nullable Output<Map<String, String>> defaultArguments) {
            this.$.defaultArguments = defaultArguments;
            return this;
        }

        public Builder defaultArguments(Map<String, String> defaultArguments) {
            return this.defaultArguments((Output<Map<String, String>>)Output.of(defaultArguments));
        }

        public Builder description(@Nullable Output<String> description) {
            this.$.description = description;
            return this;
        }

        public Builder description(String description) {
            return this.description((Output<String>)Output.of((Object)description));
        }

        public Builder executionClass(@Nullable Output<String> executionClass) {
            this.$.executionClass = executionClass;
            return this;
        }

        public Builder executionClass(String executionClass) {
            return this.executionClass((Output<String>)Output.of((Object)executionClass));
        }

        public Builder executionProperty(@Nullable Output<JobExecutionPropertyArgs> executionProperty) {
            this.$.executionProperty = executionProperty;
            return this;
        }

        public Builder executionProperty(JobExecutionPropertyArgs executionProperty) {
            return this.executionProperty((Output<JobExecutionPropertyArgs>)Output.of((Object)((Object)executionProperty)));
        }

        public Builder glueVersion(@Nullable Output<String> glueVersion) {
            this.$.glueVersion = glueVersion;
            return this;
        }

        public Builder glueVersion(String glueVersion) {
            return this.glueVersion((Output<String>)Output.of((Object)glueVersion));
        }

        public Builder maxCapacity(@Nullable Output<Double> maxCapacity) {
            this.$.maxCapacity = maxCapacity;
            return this;
        }

        public Builder maxCapacity(Double maxCapacity) {
            return this.maxCapacity((Output<Double>)Output.of((Object)maxCapacity));
        }

        public Builder maxRetries(@Nullable Output<Integer> maxRetries) {
            this.$.maxRetries = maxRetries;
            return this;
        }

        public Builder maxRetries(Integer maxRetries) {
            return this.maxRetries((Output<Integer>)Output.of((Object)maxRetries));
        }

        public Builder name(@Nullable Output<String> name) {
            this.$.name = name;
            return this;
        }

        public Builder name(String name) {
            return this.name((Output<String>)Output.of((Object)name));
        }

        public Builder nonOverridableArguments(@Nullable Output<Map<String, String>> nonOverridableArguments) {
            this.$.nonOverridableArguments = nonOverridableArguments;
            return this;
        }

        public Builder nonOverridableArguments(Map<String, String> nonOverridableArguments) {
            return this.nonOverridableArguments((Output<Map<String, String>>)Output.of(nonOverridableArguments));
        }

        public Builder notificationProperty(@Nullable Output<JobNotificationPropertyArgs> notificationProperty) {
            this.$.notificationProperty = notificationProperty;
            return this;
        }

        public Builder notificationProperty(JobNotificationPropertyArgs notificationProperty) {
            return this.notificationProperty((Output<JobNotificationPropertyArgs>)Output.of((Object)((Object)notificationProperty)));
        }

        public Builder numberOfWorkers(@Nullable Output<Integer> numberOfWorkers) {
            this.$.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public Builder numberOfWorkers(Integer numberOfWorkers) {
            return this.numberOfWorkers((Output<Integer>)Output.of((Object)numberOfWorkers));
        }

        public Builder roleArn(Output<String> roleArn) {
            this.$.roleArn = roleArn;
            return this;
        }

        public Builder roleArn(String roleArn) {
            return this.roleArn((Output<String>)Output.of((Object)roleArn));
        }

        public Builder securityConfiguration(@Nullable Output<String> securityConfiguration) {
            this.$.securityConfiguration = securityConfiguration;
            return this;
        }

        public Builder securityConfiguration(String securityConfiguration) {
            return this.securityConfiguration((Output<String>)Output.of((Object)securityConfiguration));
        }

        public Builder tags(@Nullable Output<Map<String, String>> tags) {
            this.$.tags = tags;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            return this.tags((Output<Map<String, String>>)Output.of(tags));
        }

        public Builder timeout(@Nullable Output<Integer> timeout) {
            this.$.timeout = timeout;
            return this;
        }

        public Builder timeout(Integer timeout) {
            return this.timeout((Output<Integer>)Output.of((Object)timeout));
        }

        public Builder workerType(@Nullable Output<String> workerType) {
            this.$.workerType = workerType;
            return this;
        }

        public Builder workerType(String workerType) {
            return this.workerType((Output<String>)Output.of((Object)workerType));
        }

        public JobArgs build() {
            this.$.command = Objects.requireNonNull(this.$.command, "expected parameter 'command' to be non-null");
            this.$.roleArn = Objects.requireNonNull(this.$.roleArn, "expected parameter 'roleArn' to be non-null");
            return this.$;
        }
    }
}

