/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.glacier.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;

@CustomType
public final class VaultNotification {
    private List<String> events;
    private String snsTopic;

    private VaultNotification() {
    }

    public List<String> events() {
        return this.events;
    }

    public String snsTopic() {
        return this.snsTopic;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(VaultNotification defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<String> events;
        private String snsTopic;

        public Builder() {
        }

        public Builder(VaultNotification defaults) {
            Objects.requireNonNull(defaults);
            this.events = defaults.events;
            this.snsTopic = defaults.snsTopic;
        }

        @CustomType.Setter
        public Builder events(List<String> events) {
            this.events = Objects.requireNonNull(events);
            return this;
        }

        public Builder events(String ... events) {
            return this.events(List.of(events));
        }

        @CustomType.Setter
        public Builder snsTopic(String snsTopic) {
            this.snsTopic = Objects.requireNonNull(snsTopic);
            return this;
        }

        public VaultNotification build() {
            VaultNotification o = new VaultNotification();
            o.events = this.events;
            o.snsTopic = this.snsTopic;
            return o;
        }
    }
}

