/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.fsx.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class WindowsFileSystemAuditLogConfiguration {
    @Nullable
    private String auditLogDestination;
    @Nullable
    private String fileAccessAuditLogLevel;
    @Nullable
    private String fileShareAccessAuditLogLevel;

    private WindowsFileSystemAuditLogConfiguration() {
    }

    public Optional<String> auditLogDestination() {
        return Optional.ofNullable(this.auditLogDestination);
    }

    public Optional<String> fileAccessAuditLogLevel() {
        return Optional.ofNullable(this.fileAccessAuditLogLevel);
    }

    public Optional<String> fileShareAccessAuditLogLevel() {
        return Optional.ofNullable(this.fileShareAccessAuditLogLevel);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(WindowsFileSystemAuditLogConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String auditLogDestination;
        @Nullable
        private String fileAccessAuditLogLevel;
        @Nullable
        private String fileShareAccessAuditLogLevel;

        public Builder() {
        }

        public Builder(WindowsFileSystemAuditLogConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.auditLogDestination = defaults.auditLogDestination;
            this.fileAccessAuditLogLevel = defaults.fileAccessAuditLogLevel;
            this.fileShareAccessAuditLogLevel = defaults.fileShareAccessAuditLogLevel;
        }

        @CustomType.Setter
        public Builder auditLogDestination(@Nullable String auditLogDestination) {
            this.auditLogDestination = auditLogDestination;
            return this;
        }

        @CustomType.Setter
        public Builder fileAccessAuditLogLevel(@Nullable String fileAccessAuditLogLevel) {
            this.fileAccessAuditLogLevel = fileAccessAuditLogLevel;
            return this;
        }

        @CustomType.Setter
        public Builder fileShareAccessAuditLogLevel(@Nullable String fileShareAccessAuditLogLevel) {
            this.fileShareAccessAuditLogLevel = fileShareAccessAuditLogLevel;
            return this;
        }

        public WindowsFileSystemAuditLogConfiguration build() {
            WindowsFileSystemAuditLogConfiguration o = new WindowsFileSystemAuditLogConfiguration();
            o.auditLogDestination = this.auditLogDestination;
            o.fileAccessAuditLogLevel = this.fileAccessAuditLogLevel;
            o.fileShareAccessAuditLogLevel = this.fileShareAccessAuditLogLevel;
            return o;
        }
    }
}

