/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.evidently.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class LaunchGroup {
    @Nullable
    private String description;
    private String feature;
    private String name;
    private String variation;

    private LaunchGroup() {
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public String feature() {
        return this.feature;
    }

    public String name() {
        return this.name;
    }

    public String variation() {
        return this.variation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(LaunchGroup defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String description;
        private String feature;
        private String name;
        private String variation;

        public Builder() {
        }

        public Builder(LaunchGroup defaults) {
            Objects.requireNonNull(defaults);
            this.description = defaults.description;
            this.feature = defaults.feature;
            this.name = defaults.name;
            this.variation = defaults.variation;
        }

        @CustomType.Setter
        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @CustomType.Setter
        public Builder feature(String feature) {
            this.feature = Objects.requireNonNull(feature);
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        @CustomType.Setter
        public Builder variation(String variation) {
            this.variation = Objects.requireNonNull(variation);
            return this;
        }

        public LaunchGroup build() {
            LaunchGroup o = new LaunchGroup();
            o.description = this.description;
            o.feature = this.feature;
            o.name = this.name;
            o.variation = this.variation;
            return o;
        }
    }
}

