/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.emr.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ClusterEc2Attributes {
    @Nullable
    private String additionalMasterSecurityGroups;
    @Nullable
    private String additionalSlaveSecurityGroups;
    @Nullable
    private String emrManagedMasterSecurityGroup;
    @Nullable
    private String emrManagedSlaveSecurityGroup;
    private String instanceProfile;
    @Nullable
    private String keyName;
    @Nullable
    private String serviceAccessSecurityGroup;
    @Nullable
    private String subnetId;
    @Nullable
    private List<String> subnetIds;

    private ClusterEc2Attributes() {
    }

    public Optional<String> additionalMasterSecurityGroups() {
        return Optional.ofNullable(this.additionalMasterSecurityGroups);
    }

    public Optional<String> additionalSlaveSecurityGroups() {
        return Optional.ofNullable(this.additionalSlaveSecurityGroups);
    }

    public Optional<String> emrManagedMasterSecurityGroup() {
        return Optional.ofNullable(this.emrManagedMasterSecurityGroup);
    }

    public Optional<String> emrManagedSlaveSecurityGroup() {
        return Optional.ofNullable(this.emrManagedSlaveSecurityGroup);
    }

    public String instanceProfile() {
        return this.instanceProfile;
    }

    public Optional<String> keyName() {
        return Optional.ofNullable(this.keyName);
    }

    public Optional<String> serviceAccessSecurityGroup() {
        return Optional.ofNullable(this.serviceAccessSecurityGroup);
    }

    public Optional<String> subnetId() {
        return Optional.ofNullable(this.subnetId);
    }

    public List<String> subnetIds() {
        return this.subnetIds == null ? List.of() : this.subnetIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterEc2Attributes defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String additionalMasterSecurityGroups;
        @Nullable
        private String additionalSlaveSecurityGroups;
        @Nullable
        private String emrManagedMasterSecurityGroup;
        @Nullable
        private String emrManagedSlaveSecurityGroup;
        private String instanceProfile;
        @Nullable
        private String keyName;
        @Nullable
        private String serviceAccessSecurityGroup;
        @Nullable
        private String subnetId;
        @Nullable
        private List<String> subnetIds;

        public Builder() {
        }

        public Builder(ClusterEc2Attributes defaults) {
            Objects.requireNonNull(defaults);
            this.additionalMasterSecurityGroups = defaults.additionalMasterSecurityGroups;
            this.additionalSlaveSecurityGroups = defaults.additionalSlaveSecurityGroups;
            this.emrManagedMasterSecurityGroup = defaults.emrManagedMasterSecurityGroup;
            this.emrManagedSlaveSecurityGroup = defaults.emrManagedSlaveSecurityGroup;
            this.instanceProfile = defaults.instanceProfile;
            this.keyName = defaults.keyName;
            this.serviceAccessSecurityGroup = defaults.serviceAccessSecurityGroup;
            this.subnetId = defaults.subnetId;
            this.subnetIds = defaults.subnetIds;
        }

        @CustomType.Setter
        public Builder additionalMasterSecurityGroups(@Nullable String additionalMasterSecurityGroups) {
            this.additionalMasterSecurityGroups = additionalMasterSecurityGroups;
            return this;
        }

        @CustomType.Setter
        public Builder additionalSlaveSecurityGroups(@Nullable String additionalSlaveSecurityGroups) {
            this.additionalSlaveSecurityGroups = additionalSlaveSecurityGroups;
            return this;
        }

        @CustomType.Setter
        public Builder emrManagedMasterSecurityGroup(@Nullable String emrManagedMasterSecurityGroup) {
            this.emrManagedMasterSecurityGroup = emrManagedMasterSecurityGroup;
            return this;
        }

        @CustomType.Setter
        public Builder emrManagedSlaveSecurityGroup(@Nullable String emrManagedSlaveSecurityGroup) {
            this.emrManagedSlaveSecurityGroup = emrManagedSlaveSecurityGroup;
            return this;
        }

        @CustomType.Setter
        public Builder instanceProfile(String instanceProfile) {
            this.instanceProfile = Objects.requireNonNull(instanceProfile);
            return this;
        }

        @CustomType.Setter
        public Builder keyName(@Nullable String keyName) {
            this.keyName = keyName;
            return this;
        }

        @CustomType.Setter
        public Builder serviceAccessSecurityGroup(@Nullable String serviceAccessSecurityGroup) {
            this.serviceAccessSecurityGroup = serviceAccessSecurityGroup;
            return this;
        }

        @CustomType.Setter
        public Builder subnetId(@Nullable String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        @CustomType.Setter
        public Builder subnetIds(@Nullable List<String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        public Builder subnetIds(String ... subnetIds) {
            return this.subnetIds(List.of(subnetIds));
        }

        public ClusterEc2Attributes build() {
            ClusterEc2Attributes o = new ClusterEc2Attributes();
            o.additionalMasterSecurityGroups = this.additionalMasterSecurityGroups;
            o.additionalSlaveSecurityGroups = this.additionalSlaveSecurityGroups;
            o.emrManagedMasterSecurityGroup = this.emrManagedMasterSecurityGroup;
            o.emrManagedSlaveSecurityGroup = this.emrManagedSlaveSecurityGroup;
            o.instanceProfile = this.instanceProfile;
            o.keyName = this.keyName;
            o.serviceAccessSecurityGroup = this.serviceAccessSecurityGroup;
            o.subnetId = this.subnetId;
            o.subnetIds = this.subnetIds;
            return o;
        }
    }
}

