/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.elb.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class LoadBalancerListener {
    private Integer instancePort;
    private String instanceProtocol;
    private Integer lbPort;
    private String lbProtocol;
    @Nullable
    private String sslCertificateId;

    private LoadBalancerListener() {
    }

    public Integer instancePort() {
        return this.instancePort;
    }

    public String instanceProtocol() {
        return this.instanceProtocol;
    }

    public Integer lbPort() {
        return this.lbPort;
    }

    public String lbProtocol() {
        return this.lbProtocol;
    }

    public Optional<String> sslCertificateId() {
        return Optional.ofNullable(this.sslCertificateId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(LoadBalancerListener defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private Integer instancePort;
        private String instanceProtocol;
        private Integer lbPort;
        private String lbProtocol;
        @Nullable
        private String sslCertificateId;

        public Builder() {
        }

        public Builder(LoadBalancerListener defaults) {
            Objects.requireNonNull(defaults);
            this.instancePort = defaults.instancePort;
            this.instanceProtocol = defaults.instanceProtocol;
            this.lbPort = defaults.lbPort;
            this.lbProtocol = defaults.lbProtocol;
            this.sslCertificateId = defaults.sslCertificateId;
        }

        @CustomType.Setter
        public Builder instancePort(Integer instancePort) {
            this.instancePort = Objects.requireNonNull(instancePort);
            return this;
        }

        @CustomType.Setter
        public Builder instanceProtocol(String instanceProtocol) {
            this.instanceProtocol = Objects.requireNonNull(instanceProtocol);
            return this;
        }

        @CustomType.Setter
        public Builder lbPort(Integer lbPort) {
            this.lbPort = Objects.requireNonNull(lbPort);
            return this;
        }

        @CustomType.Setter
        public Builder lbProtocol(String lbProtocol) {
            this.lbProtocol = Objects.requireNonNull(lbProtocol);
            return this;
        }

        @CustomType.Setter
        public Builder sslCertificateId(@Nullable String sslCertificateId) {
            this.sslCertificateId = sslCertificateId;
            return this;
        }

        public LoadBalancerListener build() {
            LoadBalancerListener o = new LoadBalancerListener();
            o.instancePort = this.instancePort;
            o.instanceProtocol = this.instanceProtocol;
            o.lbPort = this.lbPort;
            o.lbProtocol = this.lbProtocol;
            o.sslCertificateId = this.sslCertificateId;
            return o;
        }
    }
}

