/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.elb.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class LoadBalancerAccessLogs {
    private String bucket;
    @Nullable
    private String bucketPrefix;
    @Nullable
    private Boolean enabled;
    @Nullable
    private Integer interval;

    private LoadBalancerAccessLogs() {
    }

    public String bucket() {
        return this.bucket;
    }

    public Optional<String> bucketPrefix() {
        return Optional.ofNullable(this.bucketPrefix);
    }

    public Optional<Boolean> enabled() {
        return Optional.ofNullable(this.enabled);
    }

    public Optional<Integer> interval() {
        return Optional.ofNullable(this.interval);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(LoadBalancerAccessLogs defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String bucket;
        @Nullable
        private String bucketPrefix;
        @Nullable
        private Boolean enabled;
        @Nullable
        private Integer interval;

        public Builder() {
        }

        public Builder(LoadBalancerAccessLogs defaults) {
            Objects.requireNonNull(defaults);
            this.bucket = defaults.bucket;
            this.bucketPrefix = defaults.bucketPrefix;
            this.enabled = defaults.enabled;
            this.interval = defaults.interval;
        }

        @CustomType.Setter
        public Builder bucket(String bucket) {
            this.bucket = Objects.requireNonNull(bucket);
            return this;
        }

        @CustomType.Setter
        public Builder bucketPrefix(@Nullable String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        @CustomType.Setter
        public Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @CustomType.Setter
        public Builder interval(@Nullable Integer interval) {
            this.interval = interval;
            return this;
        }

        public LoadBalancerAccessLogs build() {
            LoadBalancerAccessLogs o = new LoadBalancerAccessLogs();
            o.bucket = this.bucket;
            o.bucketPrefix = this.bucketPrefix;
            o.enabled = this.enabled;
            o.interval = this.interval;
            return o;
        }
    }
}

