/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.elastictranscoder.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class PipelineContentConfigPermission {
    @Nullable
    private List<String> accesses;
    @Nullable
    private String grantee;
    @Nullable
    private String granteeType;

    private PipelineContentConfigPermission() {
    }

    public List<String> accesses() {
        return this.accesses == null ? List.of() : this.accesses;
    }

    public Optional<String> grantee() {
        return Optional.ofNullable(this.grantee);
    }

    public Optional<String> granteeType() {
        return Optional.ofNullable(this.granteeType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PipelineContentConfigPermission defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<String> accesses;
        @Nullable
        private String grantee;
        @Nullable
        private String granteeType;

        public Builder() {
        }

        public Builder(PipelineContentConfigPermission defaults) {
            Objects.requireNonNull(defaults);
            this.accesses = defaults.accesses;
            this.grantee = defaults.grantee;
            this.granteeType = defaults.granteeType;
        }

        @CustomType.Setter
        public Builder accesses(@Nullable List<String> accesses) {
            this.accesses = accesses;
            return this;
        }

        public Builder accesses(String ... accesses) {
            return this.accesses(List.of(accesses));
        }

        @CustomType.Setter
        public Builder grantee(@Nullable String grantee) {
            this.grantee = grantee;
            return this;
        }

        @CustomType.Setter
        public Builder granteeType(@Nullable String granteeType) {
            this.granteeType = granteeType;
            return this;
        }

        public PipelineContentConfigPermission build() {
            PipelineContentConfigPermission o = new PipelineContentConfigPermission();
            o.accesses = this.accesses;
            o.grantee = this.grantee;
            o.granteeType = this.granteeType;
            return o;
        }
    }
}

