/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.elasticbeanstalk.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GetSolutionStackResult {
    private String id;
    @Nullable
    private Boolean mostRecent;
    private String name;
    private String nameRegex;

    private GetSolutionStackResult() {
    }

    public String id() {
        return this.id;
    }

    public Optional<Boolean> mostRecent() {
        return Optional.ofNullable(this.mostRecent);
    }

    public String name() {
        return this.name;
    }

    public String nameRegex() {
        return this.nameRegex;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GetSolutionStackResult defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String id;
        @Nullable
        private Boolean mostRecent;
        private String name;
        private String nameRegex;

        public Builder() {
        }

        public Builder(GetSolutionStackResult defaults) {
            Objects.requireNonNull(defaults);
            this.id = defaults.id;
            this.mostRecent = defaults.mostRecent;
            this.name = defaults.name;
            this.nameRegex = defaults.nameRegex;
        }

        @CustomType.Setter
        public Builder id(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        @CustomType.Setter
        public Builder mostRecent(@Nullable Boolean mostRecent) {
            this.mostRecent = mostRecent;
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        @CustomType.Setter
        public Builder nameRegex(String nameRegex) {
            this.nameRegex = Objects.requireNonNull(nameRegex);
            return this;
        }

        public GetSolutionStackResult build() {
            GetSolutionStackResult o = new GetSolutionStackResult();
            o.id = this.id;
            o.mostRecent = this.mostRecent;
            o.name = this.name;
            o.nameRegex = this.nameRegex;
            return o;
        }
    }
}

