/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.elasticache;

import com.pulumi.aws.elasticache.inputs.UserAuthenticationModeArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class UserArgs
extends ResourceArgs {
    public static final UserArgs Empty = new UserArgs();
    @Import(name="accessString", required=true)
    private Output<String> accessString;
    @Import(name="authenticationMode")
    @Nullable
    private Output<UserAuthenticationModeArgs> authenticationMode;
    @Import(name="engine", required=true)
    private Output<String> engine;
    @Import(name="noPasswordRequired")
    @Nullable
    private Output<Boolean> noPasswordRequired;
    @Import(name="passwords")
    @Nullable
    private Output<List<String>> passwords;
    @Import(name="tags")
    @Nullable
    private Output<Map<String, String>> tags;
    @Import(name="userId", required=true)
    private Output<String> userId;
    @Import(name="userName", required=true)
    private Output<String> userName;

    public Output<String> accessString() {
        return this.accessString;
    }

    public Optional<Output<UserAuthenticationModeArgs>> authenticationMode() {
        return Optional.ofNullable(this.authenticationMode);
    }

    public Output<String> engine() {
        return this.engine;
    }

    public Optional<Output<Boolean>> noPasswordRequired() {
        return Optional.ofNullable(this.noPasswordRequired);
    }

    public Optional<Output<List<String>>> passwords() {
        return Optional.ofNullable(this.passwords);
    }

    public Optional<Output<Map<String, String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    public Output<String> userId() {
        return this.userId;
    }

    public Output<String> userName() {
        return this.userName;
    }

    private UserArgs() {
    }

    private UserArgs(UserArgs $) {
        this.accessString = $.accessString;
        this.authenticationMode = $.authenticationMode;
        this.engine = $.engine;
        this.noPasswordRequired = $.noPasswordRequired;
        this.passwords = $.passwords;
        this.tags = $.tags;
        this.userId = $.userId;
        this.userName = $.userName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(UserArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private UserArgs $;

        public Builder() {
            this.$ = new UserArgs();
        }

        public Builder(UserArgs defaults) {
            this.$ = new UserArgs(Objects.requireNonNull(defaults));
        }

        public Builder accessString(Output<String> accessString) {
            this.$.accessString = accessString;
            return this;
        }

        public Builder accessString(String accessString) {
            return this.accessString((Output<String>)Output.of((Object)accessString));
        }

        public Builder authenticationMode(@Nullable Output<UserAuthenticationModeArgs> authenticationMode) {
            this.$.authenticationMode = authenticationMode;
            return this;
        }

        public Builder authenticationMode(UserAuthenticationModeArgs authenticationMode) {
            return this.authenticationMode((Output<UserAuthenticationModeArgs>)Output.of((Object)((Object)authenticationMode)));
        }

        public Builder engine(Output<String> engine) {
            this.$.engine = engine;
            return this;
        }

        public Builder engine(String engine) {
            return this.engine((Output<String>)Output.of((Object)engine));
        }

        public Builder noPasswordRequired(@Nullable Output<Boolean> noPasswordRequired) {
            this.$.noPasswordRequired = noPasswordRequired;
            return this;
        }

        public Builder noPasswordRequired(Boolean noPasswordRequired) {
            return this.noPasswordRequired((Output<Boolean>)Output.of((Object)noPasswordRequired));
        }

        public Builder passwords(@Nullable Output<List<String>> passwords) {
            this.$.passwords = passwords;
            return this;
        }

        public Builder passwords(List<String> passwords) {
            return this.passwords((Output<List<String>>)Output.of(passwords));
        }

        public Builder passwords(String ... passwords) {
            return this.passwords(List.of(passwords));
        }

        public Builder tags(@Nullable Output<Map<String, String>> tags) {
            this.$.tags = tags;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            return this.tags((Output<Map<String, String>>)Output.of(tags));
        }

        public Builder userId(Output<String> userId) {
            this.$.userId = userId;
            return this;
        }

        public Builder userId(String userId) {
            return this.userId((Output<String>)Output.of((Object)userId));
        }

        public Builder userName(Output<String> userName) {
            this.$.userName = userName;
            return this;
        }

        public Builder userName(String userName) {
            return this.userName((Output<String>)Output.of((Object)userName));
        }

        public UserArgs build() {
            this.$.accessString = Objects.requireNonNull(this.$.accessString, "expected parameter 'accessString' to be non-null");
            this.$.engine = Objects.requireNonNull(this.$.engine, "expected parameter 'engine' to be non-null");
            this.$.userId = Objects.requireNonNull(this.$.userId, "expected parameter 'userId' to be non-null");
            this.$.userName = Objects.requireNonNull(this.$.userName, "expected parameter 'userName' to be non-null");
            return this.$;
        }
    }
}

