/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.eks.outputs;

import com.pulumi.aws.eks.outputs.ClusterOutpostConfigControlPlanePlacement;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ClusterOutpostConfig {
    private String controlPlaneInstanceType;
    @Nullable
    private ClusterOutpostConfigControlPlanePlacement controlPlanePlacement;
    private List<String> outpostArns;

    private ClusterOutpostConfig() {
    }

    public String controlPlaneInstanceType() {
        return this.controlPlaneInstanceType;
    }

    public Optional<ClusterOutpostConfigControlPlanePlacement> controlPlanePlacement() {
        return Optional.ofNullable(this.controlPlanePlacement);
    }

    public List<String> outpostArns() {
        return this.outpostArns;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterOutpostConfig defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String controlPlaneInstanceType;
        @Nullable
        private ClusterOutpostConfigControlPlanePlacement controlPlanePlacement;
        private List<String> outpostArns;

        public Builder() {
        }

        public Builder(ClusterOutpostConfig defaults) {
            Objects.requireNonNull(defaults);
            this.controlPlaneInstanceType = defaults.controlPlaneInstanceType;
            this.controlPlanePlacement = defaults.controlPlanePlacement;
            this.outpostArns = defaults.outpostArns;
        }

        @CustomType.Setter
        public Builder controlPlaneInstanceType(String controlPlaneInstanceType) {
            this.controlPlaneInstanceType = Objects.requireNonNull(controlPlaneInstanceType);
            return this;
        }

        @CustomType.Setter
        public Builder controlPlanePlacement(@Nullable ClusterOutpostConfigControlPlanePlacement controlPlanePlacement) {
            this.controlPlanePlacement = controlPlanePlacement;
            return this;
        }

        @CustomType.Setter
        public Builder outpostArns(List<String> outpostArns) {
            this.outpostArns = Objects.requireNonNull(outpostArns);
            return this;
        }

        public Builder outpostArns(String ... outpostArns) {
            return this.outpostArns(List.of(outpostArns));
        }

        public ClusterOutpostConfig build() {
            ClusterOutpostConfig o = new ClusterOutpostConfig();
            o.controlPlaneInstanceType = this.controlPlaneInstanceType;
            o.controlPlanePlacement = this.controlPlanePlacement;
            o.outpostArns = this.outpostArns;
            return o;
        }
    }
}

