/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.eks.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ClusterKubernetesNetworkConfig {
    @Nullable
    private String ipFamily;
    @Nullable
    private String serviceIpv4Cidr;
    @Nullable
    private String serviceIpv6Cidr;

    private ClusterKubernetesNetworkConfig() {
    }

    public Optional<String> ipFamily() {
        return Optional.ofNullable(this.ipFamily);
    }

    public Optional<String> serviceIpv4Cidr() {
        return Optional.ofNullable(this.serviceIpv4Cidr);
    }

    public Optional<String> serviceIpv6Cidr() {
        return Optional.ofNullable(this.serviceIpv6Cidr);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterKubernetesNetworkConfig defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String ipFamily;
        @Nullable
        private String serviceIpv4Cidr;
        @Nullable
        private String serviceIpv6Cidr;

        public Builder() {
        }

        public Builder(ClusterKubernetesNetworkConfig defaults) {
            Objects.requireNonNull(defaults);
            this.ipFamily = defaults.ipFamily;
            this.serviceIpv4Cidr = defaults.serviceIpv4Cidr;
            this.serviceIpv6Cidr = defaults.serviceIpv6Cidr;
        }

        @CustomType.Setter
        public Builder ipFamily(@Nullable String ipFamily) {
            this.ipFamily = ipFamily;
            return this;
        }

        @CustomType.Setter
        public Builder serviceIpv4Cidr(@Nullable String serviceIpv4Cidr) {
            this.serviceIpv4Cidr = serviceIpv4Cidr;
            return this;
        }

        @CustomType.Setter
        public Builder serviceIpv6Cidr(@Nullable String serviceIpv6Cidr) {
            this.serviceIpv6Cidr = serviceIpv6Cidr;
            return this;
        }

        public ClusterKubernetesNetworkConfig build() {
            ClusterKubernetesNetworkConfig o = new ClusterKubernetesNetworkConfig();
            o.ipFamily = this.ipFamily;
            o.serviceIpv4Cidr = this.serviceIpv4Cidr;
            o.serviceIpv6Cidr = this.serviceIpv6Cidr;
            return o;
        }
    }
}

