/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.eks;

import com.pulumi.aws.eks.inputs.FargateProfileSelectorArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class FargateProfileArgs
extends ResourceArgs {
    public static final FargateProfileArgs Empty = new FargateProfileArgs();
    @Import(name="clusterName", required=true)
    private Output<String> clusterName;
    @Import(name="fargateProfileName")
    @Nullable
    private Output<String> fargateProfileName;
    @Import(name="podExecutionRoleArn", required=true)
    private Output<String> podExecutionRoleArn;
    @Import(name="selectors", required=true)
    private Output<List<FargateProfileSelectorArgs>> selectors;
    @Import(name="subnetIds")
    @Nullable
    private Output<List<String>> subnetIds;
    @Import(name="tags")
    @Nullable
    private Output<Map<String, String>> tags;

    public Output<String> clusterName() {
        return this.clusterName;
    }

    public Optional<Output<String>> fargateProfileName() {
        return Optional.ofNullable(this.fargateProfileName);
    }

    public Output<String> podExecutionRoleArn() {
        return this.podExecutionRoleArn;
    }

    public Output<List<FargateProfileSelectorArgs>> selectors() {
        return this.selectors;
    }

    public Optional<Output<List<String>>> subnetIds() {
        return Optional.ofNullable(this.subnetIds);
    }

    public Optional<Output<Map<String, String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private FargateProfileArgs() {
    }

    private FargateProfileArgs(FargateProfileArgs $) {
        this.clusterName = $.clusterName;
        this.fargateProfileName = $.fargateProfileName;
        this.podExecutionRoleArn = $.podExecutionRoleArn;
        this.selectors = $.selectors;
        this.subnetIds = $.subnetIds;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FargateProfileArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private FargateProfileArgs $;

        public Builder() {
            this.$ = new FargateProfileArgs();
        }

        public Builder(FargateProfileArgs defaults) {
            this.$ = new FargateProfileArgs(Objects.requireNonNull(defaults));
        }

        public Builder clusterName(Output<String> clusterName) {
            this.$.clusterName = clusterName;
            return this;
        }

        public Builder clusterName(String clusterName) {
            return this.clusterName((Output<String>)Output.of((Object)clusterName));
        }

        public Builder fargateProfileName(@Nullable Output<String> fargateProfileName) {
            this.$.fargateProfileName = fargateProfileName;
            return this;
        }

        public Builder fargateProfileName(String fargateProfileName) {
            return this.fargateProfileName((Output<String>)Output.of((Object)fargateProfileName));
        }

        public Builder podExecutionRoleArn(Output<String> podExecutionRoleArn) {
            this.$.podExecutionRoleArn = podExecutionRoleArn;
            return this;
        }

        public Builder podExecutionRoleArn(String podExecutionRoleArn) {
            return this.podExecutionRoleArn((Output<String>)Output.of((Object)podExecutionRoleArn));
        }

        public Builder selectors(Output<List<FargateProfileSelectorArgs>> selectors) {
            this.$.selectors = selectors;
            return this;
        }

        public Builder selectors(List<FargateProfileSelectorArgs> selectors) {
            return this.selectors((Output<List<FargateProfileSelectorArgs>>)Output.of(selectors));
        }

        public Builder selectors(FargateProfileSelectorArgs ... selectors) {
            return this.selectors(List.of(selectors));
        }

        public Builder subnetIds(@Nullable Output<List<String>> subnetIds) {
            this.$.subnetIds = subnetIds;
            return this;
        }

        public Builder subnetIds(List<String> subnetIds) {
            return this.subnetIds((Output<List<String>>)Output.of(subnetIds));
        }

        public Builder subnetIds(String ... subnetIds) {
            return this.subnetIds(List.of(subnetIds));
        }

        public Builder tags(@Nullable Output<Map<String, String>> tags) {
            this.$.tags = tags;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            return this.tags((Output<Map<String, String>>)Output.of(tags));
        }

        public FargateProfileArgs build() {
            this.$.clusterName = Objects.requireNonNull(this.$.clusterName, "expected parameter 'clusterName' to be non-null");
            this.$.podExecutionRoleArn = Objects.requireNonNull(this.$.podExecutionRoleArn, "expected parameter 'podExecutionRoleArn' to be non-null");
            this.$.selectors = Objects.requireNonNull(this.$.selectors, "expected parameter 'selectors' to be non-null");
            return this.$;
        }
    }
}

