/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ecs.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class TaskSetLoadBalancer {
    private String containerName;
    @Nullable
    private Integer containerPort;
    @Nullable
    private String loadBalancerName;
    @Nullable
    private String targetGroupArn;

    private TaskSetLoadBalancer() {
    }

    public String containerName() {
        return this.containerName;
    }

    public Optional<Integer> containerPort() {
        return Optional.ofNullable(this.containerPort);
    }

    public Optional<String> loadBalancerName() {
        return Optional.ofNullable(this.loadBalancerName);
    }

    public Optional<String> targetGroupArn() {
        return Optional.ofNullable(this.targetGroupArn);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TaskSetLoadBalancer defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String containerName;
        @Nullable
        private Integer containerPort;
        @Nullable
        private String loadBalancerName;
        @Nullable
        private String targetGroupArn;

        public Builder() {
        }

        public Builder(TaskSetLoadBalancer defaults) {
            Objects.requireNonNull(defaults);
            this.containerName = defaults.containerName;
            this.containerPort = defaults.containerPort;
            this.loadBalancerName = defaults.loadBalancerName;
            this.targetGroupArn = defaults.targetGroupArn;
        }

        @CustomType.Setter
        public Builder containerName(String containerName) {
            this.containerName = Objects.requireNonNull(containerName);
            return this;
        }

        @CustomType.Setter
        public Builder containerPort(@Nullable Integer containerPort) {
            this.containerPort = containerPort;
            return this;
        }

        @CustomType.Setter
        public Builder loadBalancerName(@Nullable String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        @CustomType.Setter
        public Builder targetGroupArn(@Nullable String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public TaskSetLoadBalancer build() {
            TaskSetLoadBalancer o = new TaskSetLoadBalancer();
            o.containerName = this.containerName;
            o.containerPort = this.containerPort;
            o.loadBalancerName = this.loadBalancerName;
            o.targetGroupArn = this.targetGroupArn;
            return o;
        }
    }
}

