/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ecs.outputs;

import com.pulumi.aws.ecs.outputs.ServiceServiceConnectConfigurationLogConfiguration;
import com.pulumi.aws.ecs.outputs.ServiceServiceConnectConfigurationService;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ServiceServiceConnectConfiguration {
    private Boolean enabled;
    @Nullable
    private ServiceServiceConnectConfigurationLogConfiguration logConfiguration;
    @Nullable
    private String namespace;
    @Nullable
    private List<ServiceServiceConnectConfigurationService> services;

    private ServiceServiceConnectConfiguration() {
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Optional<ServiceServiceConnectConfigurationLogConfiguration> logConfiguration() {
        return Optional.ofNullable(this.logConfiguration);
    }

    public Optional<String> namespace() {
        return Optional.ofNullable(this.namespace);
    }

    public List<ServiceServiceConnectConfigurationService> services() {
        return this.services == null ? List.of() : this.services;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ServiceServiceConnectConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private Boolean enabled;
        @Nullable
        private ServiceServiceConnectConfigurationLogConfiguration logConfiguration;
        @Nullable
        private String namespace;
        @Nullable
        private List<ServiceServiceConnectConfigurationService> services;

        public Builder() {
        }

        public Builder(ServiceServiceConnectConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.enabled = defaults.enabled;
            this.logConfiguration = defaults.logConfiguration;
            this.namespace = defaults.namespace;
            this.services = defaults.services;
        }

        @CustomType.Setter
        public Builder enabled(Boolean enabled) {
            this.enabled = Objects.requireNonNull(enabled);
            return this;
        }

        @CustomType.Setter
        public Builder logConfiguration(@Nullable ServiceServiceConnectConfigurationLogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        @CustomType.Setter
        public Builder namespace(@Nullable String namespace) {
            this.namespace = namespace;
            return this;
        }

        @CustomType.Setter
        public Builder services(@Nullable List<ServiceServiceConnectConfigurationService> services) {
            this.services = services;
            return this;
        }

        public Builder services(ServiceServiceConnectConfigurationService ... services) {
            return this.services(List.of(services));
        }

        public ServiceServiceConnectConfiguration build() {
            ServiceServiceConnectConfiguration o = new ServiceServiceConnectConfiguration();
            o.enabled = this.enabled;
            o.logConfiguration = this.logConfiguration;
            o.namespace = this.namespace;
            o.services = this.services;
            return o;
        }
    }
}

