/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ecs.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ServiceNetworkConfiguration {
    @Nullable
    private Boolean assignPublicIp;
    @Nullable
    private List<String> securityGroups;
    private List<String> subnets;

    private ServiceNetworkConfiguration() {
    }

    public Optional<Boolean> assignPublicIp() {
        return Optional.ofNullable(this.assignPublicIp);
    }

    public List<String> securityGroups() {
        return this.securityGroups == null ? List.of() : this.securityGroups;
    }

    public List<String> subnets() {
        return this.subnets;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ServiceNetworkConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean assignPublicIp;
        @Nullable
        private List<String> securityGroups;
        private List<String> subnets;

        public Builder() {
        }

        public Builder(ServiceNetworkConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.assignPublicIp = defaults.assignPublicIp;
            this.securityGroups = defaults.securityGroups;
            this.subnets = defaults.subnets;
        }

        @CustomType.Setter
        public Builder assignPublicIp(@Nullable Boolean assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
            return this;
        }

        @CustomType.Setter
        public Builder securityGroups(@Nullable List<String> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder securityGroups(String ... securityGroups) {
            return this.securityGroups(List.of(securityGroups));
        }

        @CustomType.Setter
        public Builder subnets(List<String> subnets) {
            this.subnets = Objects.requireNonNull(subnets);
            return this;
        }

        public Builder subnets(String ... subnets) {
            return this.subnets(List.of(subnets));
        }

        public ServiceNetworkConfiguration build() {
            ServiceNetworkConfiguration o = new ServiceNetworkConfiguration();
            o.assignPublicIp = this.assignPublicIp;
            o.securityGroups = this.securityGroups;
            o.subnets = this.subnets;
            return o;
        }
    }
}

