/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ecs.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ServiceLoadBalancer {
    private String containerName;
    private Integer containerPort;
    @Nullable
    private String elbName;
    @Nullable
    private String targetGroupArn;

    private ServiceLoadBalancer() {
    }

    public String containerName() {
        return this.containerName;
    }

    public Integer containerPort() {
        return this.containerPort;
    }

    public Optional<String> elbName() {
        return Optional.ofNullable(this.elbName);
    }

    public Optional<String> targetGroupArn() {
        return Optional.ofNullable(this.targetGroupArn);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ServiceLoadBalancer defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String containerName;
        private Integer containerPort;
        @Nullable
        private String elbName;
        @Nullable
        private String targetGroupArn;

        public Builder() {
        }

        public Builder(ServiceLoadBalancer defaults) {
            Objects.requireNonNull(defaults);
            this.containerName = defaults.containerName;
            this.containerPort = defaults.containerPort;
            this.elbName = defaults.elbName;
            this.targetGroupArn = defaults.targetGroupArn;
        }

        @CustomType.Setter
        public Builder containerName(String containerName) {
            this.containerName = Objects.requireNonNull(containerName);
            return this;
        }

        @CustomType.Setter
        public Builder containerPort(Integer containerPort) {
            this.containerPort = Objects.requireNonNull(containerPort);
            return this;
        }

        @CustomType.Setter
        public Builder elbName(@Nullable String elbName) {
            this.elbName = elbName;
            return this;
        }

        @CustomType.Setter
        public Builder targetGroupArn(@Nullable String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public ServiceLoadBalancer build() {
            ServiceLoadBalancer o = new ServiceLoadBalancer();
            o.containerName = this.containerName;
            o.containerPort = this.containerPort;
            o.elbName = this.elbName;
            o.targetGroupArn = this.targetGroupArn;
            return o;
        }
    }
}

