/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ecr.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class RepositoryEncryptionConfiguration {
    @Nullable
    private String encryptionType;
    @Nullable
    private String kmsKey;

    private RepositoryEncryptionConfiguration() {
    }

    public Optional<String> encryptionType() {
        return Optional.ofNullable(this.encryptionType);
    }

    public Optional<String> kmsKey() {
        return Optional.ofNullable(this.kmsKey);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RepositoryEncryptionConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String encryptionType;
        @Nullable
        private String kmsKey;

        public Builder() {
        }

        public Builder(RepositoryEncryptionConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.encryptionType = defaults.encryptionType;
            this.kmsKey = defaults.kmsKey;
        }

        @CustomType.Setter
        public Builder encryptionType(@Nullable String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @CustomType.Setter
        public Builder kmsKey(@Nullable String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public RepositoryEncryptionConfiguration build() {
            RepositoryEncryptionConfiguration o = new RepositoryEncryptionConfiguration();
            o.encryptionType = this.encryptionType;
            o.kmsKey = this.kmsKey;
            return o;
        }
    }
}

