/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.ecr.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GetImageResult {
    private String id;
    private String imageDigest;
    private Integer imagePushedAt;
    private Integer imageSizeInBytes;
    @Nullable
    private String imageTag;
    private List<String> imageTags;
    @Nullable
    private Boolean mostRecent;
    private String registryId;
    private String repositoryName;

    private GetImageResult() {
    }

    public String id() {
        return this.id;
    }

    public String imageDigest() {
        return this.imageDigest;
    }

    public Integer imagePushedAt() {
        return this.imagePushedAt;
    }

    public Integer imageSizeInBytes() {
        return this.imageSizeInBytes;
    }

    public Optional<String> imageTag() {
        return Optional.ofNullable(this.imageTag);
    }

    public List<String> imageTags() {
        return this.imageTags;
    }

    public Optional<Boolean> mostRecent() {
        return Optional.ofNullable(this.mostRecent);
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GetImageResult defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String id;
        private String imageDigest;
        private Integer imagePushedAt;
        private Integer imageSizeInBytes;
        @Nullable
        private String imageTag;
        private List<String> imageTags;
        @Nullable
        private Boolean mostRecent;
        private String registryId;
        private String repositoryName;

        public Builder() {
        }

        public Builder(GetImageResult defaults) {
            Objects.requireNonNull(defaults);
            this.id = defaults.id;
            this.imageDigest = defaults.imageDigest;
            this.imagePushedAt = defaults.imagePushedAt;
            this.imageSizeInBytes = defaults.imageSizeInBytes;
            this.imageTag = defaults.imageTag;
            this.imageTags = defaults.imageTags;
            this.mostRecent = defaults.mostRecent;
            this.registryId = defaults.registryId;
            this.repositoryName = defaults.repositoryName;
        }

        @CustomType.Setter
        public Builder id(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        @CustomType.Setter
        public Builder imageDigest(String imageDigest) {
            this.imageDigest = Objects.requireNonNull(imageDigest);
            return this;
        }

        @CustomType.Setter
        public Builder imagePushedAt(Integer imagePushedAt) {
            this.imagePushedAt = Objects.requireNonNull(imagePushedAt);
            return this;
        }

        @CustomType.Setter
        public Builder imageSizeInBytes(Integer imageSizeInBytes) {
            this.imageSizeInBytes = Objects.requireNonNull(imageSizeInBytes);
            return this;
        }

        @CustomType.Setter
        public Builder imageTag(@Nullable String imageTag) {
            this.imageTag = imageTag;
            return this;
        }

        @CustomType.Setter
        public Builder imageTags(List<String> imageTags) {
            this.imageTags = Objects.requireNonNull(imageTags);
            return this;
        }

        public Builder imageTags(String ... imageTags) {
            return this.imageTags(List.of(imageTags));
        }

        @CustomType.Setter
        public Builder mostRecent(@Nullable Boolean mostRecent) {
            this.mostRecent = mostRecent;
            return this;
        }

        @CustomType.Setter
        public Builder registryId(String registryId) {
            this.registryId = Objects.requireNonNull(registryId);
            return this;
        }

        @CustomType.Setter
        public Builder repositoryName(String repositoryName) {
            this.repositoryName = Objects.requireNonNull(repositoryName);
            return this;
        }

        public GetImageResult build() {
            GetImageResult o = new GetImageResult();
            o.id = this.id;
            o.imageDigest = this.imageDigest;
            o.imagePushedAt = this.imagePushedAt;
            o.imageSizeInBytes = this.imageSizeInBytes;
            o.imageTag = this.imageTag;
            o.imageTags = this.imageTags;
            o.mostRecent = this.mostRecent;
            o.registryId = this.registryId;
            o.repositoryName = this.repositoryName;
            return o;
        }
    }
}

